/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.expressions.version2.Expression;
import stream.expressions.version2.StringExpression;
import stream.io.AbstractWriter;
import stream.service.Service;

@Description(group="Data Stream.Output")
public class CsvWriter
extends AbstractWriter
implements Service {
    static Logger log = LoggerFactory.getLogger(CsvWriter.class);
    protected PrintStream p;
    protected String separator = ",";
    protected String lastHeader;
    protected boolean headerWritten;
    protected String filter;
    protected List<String> headers;
    protected boolean closed;
    protected String urlString;
    protected URL url;
    protected File file;
    protected String lastUrlString = null;
    protected Expression<String> fileExpression;
    protected boolean header = true;
    protected Boolean append = false;

    public CsvWriter() {
    }

    public CsvWriter(URL url) throws Exception {
        this(new FileOutputStream(new File(url.toURI())));
        this.setUrl(url.toString());
    }

    public CsvWriter(File file) throws IOException {
        this(new FileOutputStream(file));
    }

    public CsvWriter(OutputStream out) {
        this(out, ",");
    }

    public CsvWriter(OutputStream out, String separator) {
        this();
        this.p = new PrintStream(out);
        this.separator = separator;
    }

    public CsvWriter(File file, String separator) throws IOException {
        this(file);
        this.separator = separator;
    }

    @Override
    @Parameter(required=true, description="The url to write to.")
    public void setUrl(String url) {
        this.urlString = url;
    }

    @Override
    public String getUrl() {
        return this.urlString;
    }

    public void setAttributeFilter(String filter) {
        this.filter = filter;
    }

    public List<String> getHeaderNames() {
        return this.headers;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Parameter(required=false, description="The separator to separate columns, usually ','", defaultValue=",")
    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public boolean isHeader() {
        return this.header;
    }

    public void setHeader(boolean header) {
        this.header = header;
    }

    public Boolean getAppend() {
        return this.append;
    }

    public void setAppend(Boolean append) {
        this.append = append;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.headers = new LinkedList<String>();
        this.closed = false;
        this.lastHeader = null;
        this.headerWritten = false;
        this.filter = ".*";
        this.fileExpression = new StringExpression(this.urlString);
    }

    @Override
    public Data processMatchingData(Data datum) {
        String expandedUrlString = null;
        try {
            expandedUrlString = (String)((Object)this.fileExpression.get((Context)this.context, datum));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (expandedUrlString == null) {
            log.error("can't find the file! {}", (Object)this.urlString);
            return datum;
        }
        if (this.p == null || this.lastUrlString == null || !expandedUrlString.equals(this.lastUrlString)) {
            if (this.p != null) {
                this.p.flush();
                this.p.close();
            }
            try {
                this.lastUrlString = expandedUrlString;
                this.url = new URL(expandedUrlString);
                this.file = new File(this.url.getPath());
                OutputStream out = this.file.getAbsolutePath().endsWith(".gz") ? new GZIPOutputStream(new FileOutputStream(this.file, (boolean)this.append)) : new FileOutputStream(this.file, (boolean)this.append);
                this.p = new PrintStream(out, false, "UTF-8");
                this.lastHeader = null;
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                log.error("Failed to open file: {}", (Object)e.getMessage());
            }
        }
        if (this.closed) {
            log.error("DataStreamWriter is closed! Not writing any more data items!");
            return datum;
        }
        if (this.header) {
            this.writeHeader(datum);
        }
        this.write(datum);
        return datum;
    }

    public void writeHeader(Data datum) {
        String header = this.createHeader(datum);
        if (this.lastHeader != null && this.lastHeader.equals(header)) {
            return;
        }
        if (this.lastHeader == null || !this.lastHeader.equals(header)) {
            this.p.println(header);
            this.lastHeader = header;
            return;
        }
        if (!this.headerWritten || this.keys == null && datum.keySet().size() > this.headers.size()) {
            Iterator<String> it = this.selectedKeys(datum).iterator();
            while (it.hasNext()) {
                String name = it.next();
                this.headers.add(name);
                this.p.print(name);
                if (!it.hasNext()) continue;
                this.p.print(this.separator);
            }
            this.p.println();
            this.headerWritten = true;
        }
    }

    @Override
    public void write(Data datum) {
        Iterator<String> it = this.selectedKeys(datum).iterator();
        while (it.hasNext()) {
            String name = it.next();
            String stringValue = "?";
            Serializable val = (Serializable)datum.get((Object)name);
            stringValue = val != null ? val.toString().replaceAll("\\n", "\\\\n") : "null";
            this.p.print(stringValue);
            if (!it.hasNext()) continue;
            this.p.print(this.separator);
        }
        this.p.println();
    }

    protected String createHeader(Data item) {
        StringWriter s = new StringWriter();
        Iterator<String> it = this.selectedKeys(item).iterator();
        while (it.hasNext()) {
            s.append(it.next());
            if (!it.hasNext()) continue;
            s.append(this.separator);
        }
        return s.toString();
    }

    public void finish() throws Exception {
        if (this.p != null) {
            this.p.flush();
            this.p.close();
        }
        this.closed = true;
    }

    public void reset() throws Exception {
        this.headers = new LinkedList<String>();
        this.closed = false;
        this.separator = ",";
        this.lastHeader = null;
        this.headerWritten = false;
    }
}

