/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;
import stream.Data;
import stream.ProcessContext;
import stream.data.DataFactory;
import stream.io.AbstractWriter;

public class DataObjectWriter
extends AbstractWriter {
    File file;
    ObjectOutputStream out;
    long cnt = 0L;
    Integer reset = 25;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.out = this.file.getAbsolutePath().endsWith(".gz") ? new ObjectOutputStream(new GZIPOutputStream(new FileOutputStream(this.file, true))) : new ObjectOutputStream(new FileOutputStream(this.file, true));
    }

    @Override
    public void write(Data input) {
        if (input != null) {
            try {
                Data store = DataFactory.create();
                for (String key : this.selectedKeys(input)) {
                    store.put((Object)key, input.get((Object)key));
                }
                this.out.writeObject(store);
                ++this.cnt;
                if (this.cnt % (long)this.reset.intValue() == 0L) {
                    this.out.reset();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void finish() throws Exception {
        super.finish();
        this.out.flush();
        this.out.close();
    }

    public Integer getReset() {
        return this.reset;
    }

    public void setReset(Integer reset) {
        this.reset = Math.max(1, reset);
    }
}

