/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import stream.Data;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.io.SourceURL;

public class RandomStream
extends AbstractStream {
    Map<String, Class<?>> attributes = new LinkedHashMap();
    Map<String, Object> store = new LinkedHashMap<String, Object>();
    Random[] random = null;
    String[] keys = new String[]{"att1"};

    public RandomStream() {
        super((SourceURL)null);
    }

    public String[] getKeys() {
        return this.keys;
    }

    @Parameter(required=false, description="The attribute names to create (comma separated)")
    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public synchronized Data readNext() throws Exception {
        Data data = DataFactory.create();
        if (this.keys == null) {
            this.keys = new String[]{"x1"};
        }
        if (this.random == null) {
            this.random = new Random[this.keys.length];
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.random[i] == null) {
                this.random[i] = new Random((long)i * 1000L);
            }
            data.put((Object)this.keys[i], (Object)this.next(this.random[i]));
        }
        return data;
    }

    public Double next(Random rnd) {
        return rnd.nextGaussian();
    }

    public Object get(String key) {
        return this.store.get(key);
    }

    public Object get(String key, Object init) {
        if (this.store.get(key) == null) {
            this.store.put(key, init);
            return init;
        }
        return this.store.get(key);
    }

    public void set(String key, Object val) {
        this.store.put(key, val);
    }
}

