/*
 * Decompiled with CFR 0.152.
 */
package stream.io;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import stream.Data;
import stream.annotations.Description;
import stream.annotations.Parameter;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.io.SourceURL;
import stream.io.sql.DatabaseDialect;
import stream.io.sql.HsqlDialect;

@Description(group="Data Stream.Sources")
public class SQLStream
extends AbstractStream {
    String username;
    String password;
    String driver;
    String select;
    Connection connection;
    ResultSet result;
    String[] columns = null;
    DatabaseDialect dialect = new HsqlDialect();

    public SQLStream(SourceURL url) {
        super(url);
    }

    public SQLStream() {
        super((SourceURL)null);
    }

    public String getSelect() {
        return this.select;
    }

    @Parameter(required=true, description="The select statement to select items from the database.")
    public void setSelect(String select) {
        this.select = select;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void init() throws Exception {
        super.init();
        try {
            log.info("Opening connection to database {}", (Object)this.getUrl());
            SourceURL url = this.getUrl();
            this.connection = DriverManager.getConnection(url.toString(), this.getUsername(), this.getPassword());
            PreparedStatement stmt = this.connection.prepareStatement(this.select);
            this.result = stmt.executeQuery();
        }
        catch (Exception e) {
            log.error("Failed to connect to database: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public Data readNext() throws Exception {
        Data instance = DataFactory.create();
        if (this.result != null && this.result.next()) {
            if (this.columns == null) {
                ResultSetMetaData meta = this.result.getMetaData();
                this.columns = new String[meta.getColumnCount()];
                for (int i = 0; i < this.columns.length; ++i) {
                    this.columns[i] = meta.getColumnName(i + 1);
                }
            }
            for (String col : this.columns) {
                Object object = this.result.getObject(col);
                String key = this.dialect.unmapColumnName(col);
                instance.put((Object)key, (Object)((Serializable)object));
            }
            return instance;
        }
        return null;
    }

    public void close() {
        try {
            if (this.result != null) {
                this.result.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

