/*
 * Decompiled with CFR 0.152.
 */
package stream.io.multi;

import stream.Data;
import stream.io.Stream;
import stream.io.multi.AbstractMultiStream;

public class RandomMultiStream
extends AbstractMultiStream {
    Double[] weights;

    public Double[] getWeights() {
        return this.weights;
    }

    public void setWeights(Double[] weights) {
        this.weights = weights;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.weights == null) {
            this.log.warn("No weights specified, using unified distribution over all streams.");
            this.weights = new Double[this.additionOrder.size()];
            for (int i = 0; i < this.weights.length; ++i) {
                this.weights[i] = 1.0 / (double)this.additionOrder.size();
            }
        } else {
            int i;
            double totalWeight = 0.0;
            for (i = 0; i < this.weights.length; ++i) {
                totalWeight += this.weights[i].doubleValue();
            }
            for (i = 0; i < this.weights.length; ++i) {
                this.weights[i] = this.weights[i] / totalWeight;
            }
        }
    }

    protected String selectNextStream() {
        if (this.additionOrder.isEmpty()) {
            return null;
        }
        double rnd = Math.random();
        double sum = 0.0;
        for (int i = 0; i < this.additionOrder.size(); ++i) {
            if (rnd >= sum && rnd < sum + this.weights[i]) {
                return (String)this.additionOrder.get(i);
            }
            sum += this.weights[i].doubleValue();
        }
        return (String)this.additionOrder.get(this.additionOrder.size() - 1);
    }

    public Data readNext() throws Exception {
        String nextKey = this.selectNextStream();
        if (nextKey == null) {
            this.log.debug("No more streams found for selection!");
            return null;
        }
        Stream stream = (Stream)this.streams.get(nextKey);
        Data nextItem = stream.read();
        if (nextItem == null) {
            this.log.info("Stream {} has ended, removing it from the multistream.", (Object)nextKey);
            this.streams.remove(nextKey);
            this.additionOrder.remove(nextKey);
            return this.readNext();
        }
        nextItem.put((Object)"@stream", (Object)nextKey);
        return nextItem;
    }
}

