/*
 * Decompiled with CFR 0.152.
 */
package stream.io.sql;

import java.util.Iterator;
import java.util.Map;
import stream.io.sql.DatabaseDialect;

public class MysqlDialect
extends DatabaseDialect {
    @Override
    public String getColumnType(Class<?> clazz) {
        if (clazz == Double.class) {
            return "REAL";
        }
        if (clazz == Long.class) {
            return "BIGINT";
        }
        if (clazz == Float.class) {
            return "REAL";
        }
        if (clazz == String.class) {
            return "TEXT";
        }
        return super.getColumnType(clazz);
    }

    @Override
    public String mapColumnName(String key) {
        return "`" + key + "`";
    }

    @Override
    public String unmapColumnName(String column) {
        String col = column;
        if (col.startsWith("`")) {
            col = col.substring(1);
        }
        if (col.endsWith("`")) {
            col = col.substring(0, col.length() - 1);
        }
        return col;
    }

    @Override
    public String getCreateTableCommand(String name, Map<String, Class<?>> types) {
        Object primaryKey = null;
        StringBuffer s = new StringBuffer();
        s.append("CREATE TABLE " + name + " (\n");
        Iterator<String> it = types.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            String colName = this.mapColumnName(key);
            String colType = this.getColumnType(types.get(key));
            if (key.startsWith("@id") && primaryKey == null) {
                colType = this.getColumnType(types.get(key)) + " NOT NULL PRIMARY KEY ";
                if (types.get(key) == Integer.class || types.get(key) == Long.class) {
                    colType = colType + " AUTO_INCREMENT";
                }
            }
            s.append(" ");
            s.append(colName);
            s.append(" ");
            s.append(colType);
            if (!it.hasNext()) continue;
            s.append(",\n");
        }
        s.append(" )\n");
        return s.toString();
    }
}

