/*
 * Decompiled with CFR 0.152.
 */
package stream.learner.evaluation;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Description;
import stream.learner.evaluation.ConfusionMatrix;
import stream.learner.evaluation.LossFunction;
import stream.learner.evaluation.TableOfConfusion;
import stream.learner.evaluation.ZeroOneLoss;

@Description(name="PredictionError", group="Data Stream.Mining.Evaluation")
public class PredictionError
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(PredictionError.class);
    LossFunction<Serializable> loss = new ZeroOneLoss<Serializable>();
    String prefix = "@error";
    String label = "@label";
    String[] learner;
    Integer count = 0;
    Integer every = 0;
    protected Map<String, ConfusionMatrix<Serializable>> confusionMatrices = new LinkedHashMap<String, ConfusionMatrix<Serializable>>();

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String[] getLearner() {
        return this.learner;
    }

    public void setLearner(String[] learner) {
        this.learner = learner;
    }

    public Data process(Data data) {
        Serializable labelValue = (Serializable)data.get((Object)this.label);
        if (labelValue == null) {
            return data;
        }
        LinkedHashMap<String, Double> errors = new LinkedHashMap<String, Double>();
        if (this.learner != null) {
            for (String classifier : this.learner) {
                String key = "@prediction:" + (String)classifier;
                Serializable pred = (Serializable)data.get((Object)key);
                if (pred == null) continue;
                Double error = this.loss.loss(labelValue, pred);
                errors.put(this.prefix + (String)classifier, error);
                ConfusionMatrix<Serializable> matrix = this.confusionMatrices.get(classifier);
                if (matrix == null) {
                    matrix = new ConfusionMatrix();
                    this.confusionMatrices.put(classifier, matrix);
                }
                matrix.add(labelValue, pred);
            }
        } else {
            for (String key : data.keySet()) {
                if (!key.startsWith("@prediction")) continue;
                Serializable pred = (Serializable)data.get((Object)key);
                String name = key.substring("@prediction".length());
                String errKey = key.replaceFirst("@prediction", this.prefix);
                if (pred == null) continue;
                Double error = this.loss.loss(labelValue, pred);
                errors.put(errKey, error);
                ConfusionMatrix<Serializable> matrix = this.confusionMatrices.get(name);
                if (matrix == null) {
                    matrix = new ConfusionMatrix();
                    this.confusionMatrices.put(name, matrix);
                }
                matrix.add(labelValue, pred);
            }
        }
        for (String err : errors.keySet()) {
            data.put((Object)err, errors.get(err));
        }
        Integer n = this.count;
        Integer err = this.count = Integer.valueOf(this.count + 1);
        if (this.every > 0 && this.count % this.every == 0) {
            for (String learner : this.confusionMatrices.keySet()) {
                log.info(this.confusionMatrices.get(learner).toString());
            }
        }
        return data;
    }

    public void finish() throws Exception {
        super.finish();
        for (String learner : this.confusionMatrices.keySet()) {
            log.info(this.confusionMatrices.get(learner).toString());
            StringBuffer config = new StringBuffer("\\begin{tabular}{p{2cm}");
            StringBuffer header = new StringBuffer("\\textbf{Label} ");
            StringBuffer body = new StringBuffer("Accuracy ");
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setDecimalSeparator('.');
            DecimalFormat fmt = new DecimalFormat("0.00", dfs);
            ConfusionMatrix<Serializable> matrix = this.confusionMatrices.get(learner);
            List<Serializable> labels = matrix.getLabels();
            for (Serializable label : labels) {
                config.append("|c");
                header.append("& \\textbf{" + label + "} ");
                TableOfConfusion conf = matrix.getTableOfConfusion(label);
                double acc = conf.calculateAccuracy();
                body.append(" & " + fmt.format(acc) + " ");
            }
            config.append("|} \\\\ \\hline");
            header.append("\\\\ \\hline");
            body.append("\\\\ \\hline");
            body.append("\n");
            body.append("\\end{tabular}");
            System.out.println(config.toString());
            System.out.println(header.toString());
            System.out.println(body.toString());
        }
    }
}

