/*
 * Decompiled with CFR 0.152.
 */
package stream.lookup;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.annotations.Parameter;
import stream.io.SourceURL;
import stream.io.Stream;
import stream.runtime.ApplicationContext;
import stream.runtime.LifeCycle;
import stream.service.LookupService;

public abstract class AbstractDatabase
implements LookupService,
LifeCycle {
    static Logger log = LoggerFactory.getLogger(AbstractDatabase.class);
    final Map<String, Data> database = new LinkedHashMap<String, Data>();
    String key = "@id";
    SourceURL url;

    public void reset() throws Exception {
        log.debug("Re-reading database...");
        LinkedHashMap<String, Data> db = new LinkedHashMap<String, Data>();
        this.populateDatabase(this.url, db);
        this.database.clear();
        this.database.putAll(db);
    }

    public void init(ApplicationContext context) throws Exception {
        if (this.url == null) {
            throw new Exception("No 'url' attribute specified!");
        }
        this.populateDatabase(this.url, this.database);
    }

    protected abstract void populateDatabase(SourceURL var1, Map<String, Data> var2) throws Exception;

    protected void readDatabase(Stream stream, Map<String, Data> database) throws Exception {
        Data item = stream.read();
        while (item != null) {
            Serializable value = (Serializable)item.get((Object)this.key);
            if (value == null) {
                log.error("Missing attribute '{}' in item read from URL: {}", (Object)this.key, (Object)item);
            } else {
                log.debug("Adding item for key '{}': {}", (Object)value, (Object)item);
                database.put(value.toString(), item);
            }
            item = stream.read();
        }
        log.info("{} items read from source {}.", (Object)database.size(), (Object)stream);
    }

    public void finish() throws Exception {
    }

    @Override
    public Data lookup(String key) {
        Data item = this.database.get(key);
        log.debug("Found item for key '{}': {}", (Object)key, (Object)item);
        return item;
    }

    public String getKey() {
        return this.key;
    }

    @Parameter(description="The lookup-key that is used for storing items in the lookup table. This key must be present in the items that are being read from the datasource while populating the database. Default value is '@id'.", required=false)
    public void setKey(String key) {
        this.key = key;
    }

    public SourceURL getUrl() {
        return this.url;
    }

    @Parameter(description="The source URL from which data should be read at startup. This data is then used for populating the lookup table.", required=true)
    public void setUrl(SourceURL url) {
        this.url = url;
    }
}

