/*
 * Decompiled with CFR 0.152.
 */
package stream.monitor;

import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRateGroup {
    static Logger log = LoggerFactory.getLogger(DataRateGroup.class);
    static final Map<String, DataRateGroup> groups = new LinkedHashMap<String, DataRateGroup>();
    final Object lock = new Object();
    final Set<String> members = new LinkedHashSet<String>();
    final Map<String, Result> results = new LinkedHashMap<String, Result>();
    final String groupId;

    public static synchronized DataRateGroup get(String groupId) {
        DataRateGroup group = groups.get(groupId);
        if (group == null) {
            group = new DataRateGroup(groupId);
            groups.put(groupId, group);
        }
        return group;
    }

    public DataRateGroup(String id) {
        this.groupId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String id) {
        Object object = this.lock;
        synchronized (object) {
            this.members.add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String id, Result result) {
        Object object = this.lock;
        synchronized (object) {
            this.results.put(id, result);
            if (this.results.size() == this.members.size()) {
                System.out.println("DataGroup results complete!");
                this.dumpResults();
            }
        }
    }

    public void dumpResults() {
        Long min = null;
        Long max = null;
        Double sum = 0.0;
        for (Result result : this.results.values()) {
            if (min == null) {
                min = result.start;
            }
            if (max == null) {
                max = result.end;
            }
            min = Math.min(min, result.start);
            max = Math.max(max, result.end);
            sum = sum + (double)result.items;
        }
        Double time = (double)(max - min) / 1000.0;
        DecimalFormat fmt = new DecimalFormat("0.000");
        log.info("Averaged total data rate for group '{}' is: {} items/sec", (Object)this.groupId, (Object)fmt.format(sum / time));
    }

    public static class Result {
        public final String id;
        public final long start;
        public final long end;
        public final long items;

        public Result(String id, long start, long end, long items) {
            this.id = id;
            this.start = start;
            this.end = end;
            this.items = items;
        }
    }
}

