/*
 * Decompiled with CFR 0.152.
 */
package stream.monitor;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.data.DataFactory;
import stream.io.AbstractStream;
import stream.util.Time;

public class VmStats
extends AbstractStream {
    static Logger log = LoggerFactory.getLogger(VmStats.class);
    String[] paths = new String[]{"/usr/bin", "/usr/sbin", "/usr/local/bin", "/usr/local/sbin"};
    String[] vmStats = new String[]{"vmstat", "vm_stat"};
    File vmstat = null;
    Process process;
    BufferedReader reader;
    Time interval = new Time(Long.valueOf(5000L));
    final ArrayList<String> keys = new ArrayList();

    public void init() throws Exception {
        super.init();
        for (String path : this.paths) {
            for (String probe : this.vmStats) {
                File f = new File(path + File.separator + probe);
                if (!f.canExecute()) continue;
                this.vmstat = f;
                break;
            }
            if (this.vmstat != null) break;
        }
        if (this.vmstat == null) {
            throw new Exception("Failed to locate vm_stat/vmstat utility!");
        }
        String cmd = this.vmstat.getAbsolutePath();
        Integer time = Math.max(1, this.interval.asSeconds().intValue());
        this.process = Runtime.getRuntime().exec(new String[]{cmd, time.toString()});
        this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
    }

    public Data readNext() throws Exception {
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        if (line.trim().startsWith("Mach") || line.trim().startsWith("proc")) {
            line = this.reader.readLine();
            String[] headers = line.trim().split("\\s+");
            this.keys.clear();
            for (String header : headers) {
                if (header.trim().isEmpty()) continue;
                this.keys.add(header.trim());
            }
            line = this.reader.readLine();
        }
        String[] vals = line.trim().split("\\s+");
        Data item = DataFactory.create();
        item.put((Object)"@timestamp", (Object)System.currentTimeMillis());
        for (int i = 0; i < this.keys.size() && i < vals.length; ++i) {
            String key = this.keys.get(i);
            String val = vals[i];
            Object value = val;
            try {
                value = val.toLowerCase().endsWith("k") ? new Double(val.substring(0, val.length() - 1)) : new Double(val);
            }
            catch (Exception e) {
                value = vals[i];
            }
            item.put((Object)("vmstats:" + key), value);
        }
        return item;
    }

    public void close() throws Exception {
        super.close();
        this.process.destroy();
    }

    public Time getInterval() {
        return this.interval;
    }

    public void setInterval(Time interval) {
        this.interval = interval;
    }

    public static void main(String[] args) throws Exception {
        VmStats vmstats = new VmStats();
        vmstats.setLimit(100L);
        vmstats.init();
        Data item = vmstats.read();
        while (item != null) {
            log.info("item: {}", (Object)item);
            item = vmstats.read();
        }
        vmstats.close();
    }
}

