/*
 * Decompiled with CFR 0.152.
 */
package stream.statistics;

import stream.Data;
import stream.annotations.Description;
import stream.statistics.StatisticsLearner;

@Description(group="Data Stream.Processing.Statistics", text="Continuously determines the minimum values for numeric attributes")
public class Minima
extends StatisticsLearner {
    @Override
    public void updateStatistics(Data item) {
        if (this.keys == null) {
            return;
        }
        for (String key : this.keys) {
            Double val = null;
            try {
                val = new Double(item.get((Object)key) + "");
            }
            catch (Exception e) {
                val = null;
            }
            Double cur = this.statistics.get((Object)key);
            if (val == null) continue;
            if (cur == null) {
                this.statistics.put((Object)key, (Object)val);
            } else {
                this.statistics.put((Object)key, (Object)Math.min(cur, val));
            }
            if (this.prefix != null) {
                item.put((Object)(this.prefix + key), (Object)this.statistics.get((Object)key));
                continue;
            }
            item.put((Object)key, (Object)this.statistics.get((Object)key));
        }
    }
}

