/*
 * Decompiled with CFR 0.152.
 */
package stream.text;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.annotations.Parameter;

public class FillTemplate
extends AbstractProcessor {
    public static final String VAR_PREFIX = "${";
    public static final String VAR_SUFFIX = "}";
    static Logger log = LoggerFactory.getLogger(FillTemplate.class);
    String key = null;
    boolean emptyStrings = true;

    public String getKey() {
        return this.key;
    }

    @Parameter(required=true, description="The attribute that contains the template to fill.")
    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEmptyStrings() {
        return this.emptyStrings;
    }

    @Parameter(required=false, defaultValue="false", description="Whether to expand non-existing variables to empty strings.")
    public void setEmptyStrings(boolean emptyStrings) {
        this.emptyStrings = emptyStrings;
    }

    public Data process(Data input) {
        if (this.key == null || !input.containsKey((Object)this.key)) {
            return input;
        }
        String text = ((Serializable)input.get((Object)this.key)).toString();
        HashMap<String, String> vars = new HashMap<String, String>();
        for (String k : input.keySet()) {
            vars.put("data." + k, ((Serializable)input.get((Object)k)).toString());
        }
        String expanded = this.substitute(text, this.emptyStrings, vars);
        input.put((Object)this.key, (Object)expanded);
        return input;
    }

    private String substitute(String str, boolean emptyStrings, Map<String, String> vars) {
        String content = str;
        int start = content.indexOf(VAR_PREFIX, 0);
        while (start >= 0) {
            int end = content.indexOf(VAR_SUFFIX, start + 1);
            if (end >= start + 2) {
                String variable = content.substring(start + 2, end);
                log.debug("Found variable: {}", (Object)variable);
                log.trace("   content is: {}", (Object)content);
                int len = variable.length();
                if (vars.containsKey(variable)) {
                    String repl = vars.get(variable);
                    content = content.substring(0, start) + vars.get(variable) + content.substring(end + 1);
                    len = repl.length();
                } else if (emptyStrings) {
                    content = content.substring(0, start) + "" + content.substring(end + 1);
                    len = 0;
                } else {
                    content = content.substring(0, start) + VAR_PREFIX + variable + VAR_SUFFIX + content.substring(end + 1);
                }
                if (end < content.length()) {
                    start = content.indexOf(VAR_PREFIX, start + len);
                    continue;
                }
                start = -1;
                continue;
            }
            start = -1;
        }
        return content;
    }
}

