package streams.esper;

/*
 * #%L
 * Esper implementation of Streams Nodes
 * %%
 * Copyright (C) 2013 University of Zurich
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * <p>
 * An Esper data item extends the {@link stream.Data} by a setter method for the
 * map properties. This allows to re-user <a href=
 * "http://esper.codehaus.org/esper-4.10.0/doc/reference/en-US/html_single/index.html#event-properties-indexedmappedsetter"
 * >Esper types</a> and we hence have to define no further types.
 * </p>
 * 
 * @author Thomas Scharrenbach
 * @version 0.3.0
 * @since 0.3.0
 * 
 */
public class EsperData implements stream.Data {

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	// Remember to change the version UID when changing this class!!!
	private static final long serialVersionUID = 2L;

	//
	//
	//

	private final stream.Data _item;

	//
	//
	//

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	public EsperData(stream.Data item) {
		_item = item;
	}

	//
	//
	//

	/**
	 * 
	 * @param key
	 * @param value
	 */
	public void setProps(String key, Serializable value) {
		_item.put(key, value);
	}

	//
	//
	//
	
	/**
	 * <p>select item('key')</p>
	 * 
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	public stream.Data getItem() {
		return this;
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public Serializable get(Object key) {
		return _item.get(key);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public boolean isEmpty() {
		return _item.isEmpty();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public Set<String> keySet() {
		return _item.keySet();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public Serializable put(String key, Serializable value) {
		return _item.put(key, value);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public void putAll(Map<? extends String, ? extends Serializable> m) {
		_item.putAll(m);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public Serializable remove(Object key) {
		return _item.remove(key);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public int size() {
		return _item.size();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public Collection<Serializable> values() {
		return _item.values();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public void clear() {
		_item.clear();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public boolean containsKey(Object key) {
		return _item.containsKey(key);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public boolean containsValue(Object value) {
		return _item.containsValue(value);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public stream.Data createCopy() {
		return _item.createCopy();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public Set<java.util.Map.Entry<String, Serializable>> entrySet() {
		return _item.entrySet();
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public boolean equals(Object arg0) {
		return _item.equals(arg0);
	}

	/**
	 * @version 0.3.0
	 * @since 0.3.0
	 * 
	 */
	@Override
	public int hashCode() {
		return _item.hashCode();
	}

}
