package streams.esper;

/*
 * #%L
 * Esper implementation of Streams Nodes
 * %%
 * Copyright (C) 2013 University of Zurich
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/**
 * 
 * @author Thomas Scharrenbach
 * @version 0.3.0
 * @since 0.3.0
 * 
 */
public class EsperEngineElementHandler implements stream.runtime.ElementHandler {

	public static final String ELEMENT_NAME = "EsperEngine";

	public static final String ATTRIBUTE_ID = "id";

	public static final String ATTRIBUTE_URI = "uri";

	public static final String ATTRIBUTE_TYPES = "types";

	public static final String ATTRIBUTE_INITIAL_TIME = "initialTime";

	public static final String ATTRIBUTE_TIME_TOLERANCE = "timeTolerance";

	private static final String ERROR_MESSAGE_MISSING_ATTRIBUTE = "Attribute %s must be specified!";

	public static final String KEY = ELEMENT_NAME;

	//
	//
	//

	@Override
	public String getKey() {
		return KEY;
	}

	@Override
	public void handleElement(stream.runtime.ProcessContainer container, Element element,
			stream.util.Variables variables, stream.runtime.DependencyInjection dependencies)
			throws Exception {
		final EsperEngine engine = new EsperEngine();

		// Set the id attribute.
		if (element.hasAttribute(ATTRIBUTE_ID)) {
			engine.setId(element.getAttribute(ATTRIBUTE_ID));
		}
		// The id attribute is required!
		else {
			final String errorMessage = String.format(
					ERROR_MESSAGE_MISSING_ATTRIBUTE, "id");
			throw new IllegalArgumentException(errorMessage);
		}

		if (element.hasAttribute(ATTRIBUTE_URI)) {
			engine.setProviderUri(element.getAttribute(ATTRIBUTE_URI));
		}

		if (element.hasAttribute(ATTRIBUTE_INITIAL_TIME)) {
			engine.setInitialTime(Long.parseLong(element
					.getAttribute(ATTRIBUTE_INITIAL_TIME)));
		}

		if (element.hasAttribute(ATTRIBUTE_TIME_TOLERANCE)) {
			engine.setTimeTolerance(Long.parseLong(element
					.getAttribute(ATTRIBUTE_TIME_TOLERANCE)));
		}

		if (element.hasAttribute(ATTRIBUTE_TYPES)) {
			engine.setTypes(element.getAttribute(ATTRIBUTE_TYPES).split(","));
		}

		final NodeList configurationElementList = element
				.getElementsByTagName("config");
		final int configurationElementListSize = configurationElementList
				.getLength();

		for (int i = 0; i < configurationElementListSize; ++i) {
			engine.configure((Element) configurationElementList.item(i));
		}
		engine.init();
	}

	@Override
	public boolean handlesElement(Element element) {
		return element != null && element.getLocalName().equals(ELEMENT_NAME);
	}

}
