package streams.esper;

/*
 * #%L
 * Esper implementation of Streams Nodes
 * %%
 * Copyright (C) 2013 University of Zurich
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import stream.io.Sink;

/**
 * Simple Java bean for representing Esper statements.
 * 
 * @author Thomas Scharrenbach
 * @version 0.3.0
 * @since 0.3.0
 * 
 */
public class EsperStatementBean {

	public static final boolean DEFAULT_BACKQUOTED_KEYS = false;

	public static final Sink[] DEFAULT_OUTPUT = null;

	public static final String DEFAULT_NAME = null;

	//
	//
	//

	private String _statement;

	private String _name;

	private Sink[] _output;

	private boolean _removeBackticks;

	//
	//
	//

	/**
	 * Initialize default values.
	 */
	public EsperStatementBean() {
		_removeBackticks = DEFAULT_BACKQUOTED_KEYS;
		_output = DEFAULT_OUTPUT;
		_name = DEFAULT_NAME;
	}

	//
	//
	//

	/**
	 * @return the name, if the name is not null, else {@link Object#toString()}
	 *         .
	 */
	@Override
	public String toString() {
		return _name == null ? super.toString() : _name;
	}

	/**
	 * @return the hascode of the name, if the name is not null, else
	 *         {@link Object#hashCode()}.
	 */
	@Override
	public int hashCode() {
		return _name == null ? super.hashCode() : _name.hashCode();
	}

	/**
	 * @return a hash code comparison without casting.
	 */
	@Override
	public boolean equals(Object obj) {
		return obj != null && this.hashCode() == obj.hashCode();
	}

	//
	//
	//

	public void setName(String name) {
		_name = name;
	}

	public String getName() {
		return _name;
	}

	public void setStatement(String statement) {
		_statement = statement;
	}

	public String getStatement() {
		return _statement;
	}

	public void setOutput(Sink[] output) {
		_output = output;
	}

	public Sink[] getOutput() {
		return _output;
	}

	public void setRemoveBackticks(boolean removeBackticks) {
		_removeBackticks = removeBackticks;
	}

	public boolean isRemoveBackticks() {
		return _removeBackticks;
	}

}
