package streams.esper;

/*
 * #%L
 * Esper implementation of Streams Nodes
 * %%
 * Copyright (C) 2013 University of Zurich
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

import com.espertech.esper.client.soda.Stream;

/**
 * Visit Esper {@link com.espertech.esper.client.soda.Stream} objects.
 * 
 * @author Thomas Scharrenbach
 * @version 0.3.0
 * @since 0.3.0
 * 
 */
public interface EsperStreamVisitor {

	void visit(com.espertech.esper.client.soda.MethodInvocationStream stream);

	void visit(com.espertech.esper.client.soda.FilterStream stream);

	void visit(com.espertech.esper.client.soda.PatternStream stream);

	void visit(com.espertech.esper.client.soda.SQLStream stream);

	/**
	 * This is the method to be called.
	 * 
	 * @param stream
	 */
	void visitStream(Stream stream);

}
