/*
 * Decompiled with CFR 0.152.
 */
package streams.esper;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import stream.runtime.DependencyInjection;
import stream.runtime.ElementHandler;
import stream.runtime.ProcessContainer;
import stream.util.Variables;
import streams.esper.EsperEngine;

public class EsperEngineElementHandler
implements ElementHandler {
    public static final String ELEMENT_NAME = "EsperEngine";
    public static final String ATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_URI = "uri";
    public static final String ATTRIBUTE_TYPES = "types";
    public static final String ATTRIBUTE_INITIAL_TIME = "initialTime";
    public static final String ATTRIBUTE_TIME_TOLERANCE = "timeTolerance";
    private static final String ERROR_MESSAGE_MISSING_ATTRIBUTE = "Attribute %s must be specified!";
    public static final String KEY = "EsperEngine";

    public String getKey() {
        return "EsperEngine";
    }

    public void handleElement(ProcessContainer container, Element element, Variables variables, DependencyInjection dependencies) throws Exception {
        EsperEngine engine = new EsperEngine();
        if (!element.hasAttribute(ATTRIBUTE_ID)) {
            String errorMessage = String.format(ERROR_MESSAGE_MISSING_ATTRIBUTE, ATTRIBUTE_ID);
            throw new IllegalArgumentException(errorMessage);
        }
        engine.setId(element.getAttribute(ATTRIBUTE_ID));
        if (element.hasAttribute(ATTRIBUTE_URI)) {
            engine.setProviderUri(element.getAttribute(ATTRIBUTE_URI));
        }
        if (element.hasAttribute(ATTRIBUTE_INITIAL_TIME)) {
            engine.setInitialTime(Long.parseLong(element.getAttribute(ATTRIBUTE_INITIAL_TIME)));
        }
        if (element.hasAttribute(ATTRIBUTE_TIME_TOLERANCE)) {
            engine.setTimeTolerance(Long.parseLong(element.getAttribute(ATTRIBUTE_TIME_TOLERANCE)));
        }
        if (element.hasAttribute(ATTRIBUTE_TYPES)) {
            engine.setTypes(element.getAttribute(ATTRIBUTE_TYPES).split(","));
        }
        NodeList configurationElementList = element.getElementsByTagName("config");
        int configurationElementListSize = configurationElementList.getLength();
        for (int i = 0; i < configurationElementListSize; ++i) {
            engine.configure((Element)configurationElementList.item(i));
        }
        engine.init();
    }

    public boolean handlesElement(Element element) {
        return element != null && element.getLocalName().equals("EsperEngine");
    }
}

