/*
 * Decompiled with CFR 0.152.
 */
package streams.esper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import stream.Data;
import stream.data.DataFactory;
import stream.io.Sink;

public class EsperStatementSubscriber {
    public static final String KEY_STREAM = "@stream";
    private final Sink[] _sinksList;
    private String[] _sinksListId;
    private final String[] _keys;

    public EsperStatementSubscriber(List<Sink> sinksList, String[] keys) {
        this._sinksList = sinksList.toArray(new Sink[sinksList.size()]);
        this._sinksListId = new String[this._sinksList.length];
        this._keys = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this._keys[i] = keys[i].replace('`', ' ').trim();
        }
        for (int s = 0; s < this._sinksList.length; ++s) {
            this._sinksListId[s] = this._sinksList[s].getId();
        }
    }

    public void update(Serializable ... values) throws Exception {
        Data item = DataFactory.create();
        for (int i = 0; i < values.length; ++i) {
            item.put((Object)this._keys[i], (Object)values[i]);
        }
        this.write(item);
    }

    public void update(Map<String, Serializable> values) throws Exception {
        Data item = DataFactory.create();
        for (Map.Entry<String, Serializable> entry : values.entrySet()) {
            item.put((Object)entry.getKey().replace('`', ' ').trim(), (Object)entry.getValue());
        }
        this.write(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(Data item) throws Exception {
        item.put((Object)KEY_STREAM, (Object)this._sinksListId[0]);
        Sink[] sinkArray = this._sinksList;
        synchronized (this._sinksList) {
            this._sinksList[0].write(item);
            for (int s = 1; s < this._sinksList.length; ++s) {
                Data result = DataFactory.copy((Data)item);
                result.put((Object)KEY_STREAM, (Object)this._sinksListId[s]);
                this._sinksList[s].write(result);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

