/*
 * Decompiled with CFR 0.152.
 */
package streams.esper;

import com.espertech.esper.client.ConfigurationOperations;
import com.espertech.esper.client.soda.FilterStream;
import com.espertech.esper.client.soda.MethodInvocationStream;
import com.espertech.esper.client.soda.PatternStream;
import com.espertech.esper.client.soda.SQLStream;
import com.espertech.esper.client.soda.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import streams.esper.EsperData;
import streams.esper.EsperStreamVisitor;

public class EsperStreamEventTypeVisitor
implements EsperStreamVisitor {
    private static final Logger _log = LoggerFactory.getLogger(EsperStreamEventTypeVisitor.class);
    private final ConfigurationOperations _esperConfiguration;

    public EsperStreamEventTypeVisitor(ConfigurationOperations configurationOperations) {
        this._esperConfiguration = configurationOperations;
    }

    @Override
    public void visitStream(Stream stream) {
        if (stream instanceof MethodInvocationStream) {
            this.visit((MethodInvocationStream)stream);
        } else if (stream instanceof FilterStream) {
            this.visit((FilterStream)stream);
        } else if (stream instanceof PatternStream) {
            this.visit((PatternStream)stream);
        } else if (stream instanceof SQLStream) {
            this.visit((SQLStream)stream);
        } else {
            throw new IllegalArgumentException(String.format("Cannot visit Esper stream of type %s", stream.getClass()));
        }
    }

    @Override
    public void visit(MethodInvocationStream stream) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    public void visit(FilterStream stream) {
        String eventTypeName = stream.getFilter().getEventTypeName();
        if (this._esperConfiguration.getEventType(eventTypeName) == null) {
            _log.info("Event type {} not yet included in Esper configuration, declaring new streams-esper EsperData", (Object)eventTypeName);
            this._esperConfiguration.addEventType(eventTypeName, EsperData.class);
        }
    }

    @Override
    public void visit(PatternStream stream) {
    }

    @Override
    public void visit(SQLStream stream) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }
}

