/*
 * Decompiled with CFR 0.152.
 */
package streams.esper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import stream.AbstractProcessor;
import stream.Configurable;
import stream.Data;
import stream.ProcessContext;
import stream.annotations.BodyContent;
import stream.annotations.Parameter;
import stream.annotations.Service;
import stream.data.DataFactory;
import stream.io.Sink;
import streams.esper.EsperEngine;
import streams.esper.EsperStatementBean;

public class Query
extends AbstractProcessor
implements Configurable {
    static final Logger log = LoggerFactory.getLogger(Query.class);
    private Sink[] _output;
    private String _engineId;
    private String _esperStatement;
    @Service(required=false)
    private EsperEngine esperEngine;
    private String _name;
    private boolean _removeBackticks;
    private String _inputType;
    private boolean _forward = false;

    public Data process(Data input) {
        try {
            if (input != null) {
                this.esperEngine.write(input);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this._forward ? input : DataFactory.create();
    }

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        if (this._engineId == null) {
            this._engineId = "default";
        }
        this.esperEngine = EsperEngine.getEsperEngine(this._engineId);
        if (this.esperEngine == null) {
            String errorMessage = "No Esper engine configured!";
            throw new NullPointerException("No Esper engine configured!");
        }
        EsperStatementBean epStatement = new EsperStatementBean();
        epStatement.setName(this.getName());
        epStatement.setOutput(this.getOutput());
        epStatement.setStatement(this.getQuery());
        epStatement.setRemoveBackticks(this.isRemoveBackticks());
        this.esperEngine.addEsperQuery(epStatement, true);
    }

    public void finish() throws Exception {
        log.info("Esper query '{}' finished, notifying Esper engine...", (Object)this._name);
        this.esperEngine.notifyShutdown();
        super.finish();
    }

    public String getQuery() {
        log.debug("Returning esper query statement: '{}'", (Object)this._esperStatement);
        return this._esperStatement;
    }

    protected EsperEngine getEsperEngine() {
        return this.esperEngine;
    }

    protected void setEsperEngine(EsperEngine esperEngine) {
        this.esperEngine = esperEngine;
    }

    public void setQuery(BodyContent esperQuery) {
        if (this._esperStatement != null) {
            String errorMessage = String.format("Parameter %s already defined.", "query");
            throw new IllegalArgumentException(errorMessage);
        }
        this._esperStatement = esperQuery.getContent();
        log.debug("Esper query is: '{}'", (Object)this._esperStatement);
    }

    @Parameter
    public void setOutput(Sink[] output) {
        if (this._output != null) {
            String errorMessage = String.format("Parameter %s already defined.", "output");
            throw new IllegalArgumentException(errorMessage);
        }
        this._output = output;
    }

    public Sink[] getOutput() {
        return this._output;
    }

    @Parameter(defaultValue="default", required=false)
    public void setEngine(String engine) {
        if (this._engineId != null) {
            String errorMessage = String.format("Parameter %s already defined.", "engine");
            throw new IllegalArgumentException(errorMessage);
        }
        this._engineId = engine;
    }

    public String getEngine() {
        return this._engineId;
    }

    @Parameter(required=false, description="The optional name for the Esper statement.")
    public void setName(String name) {
        if (this._name != null) {
            String errorMessage = String.format("Parameter %s already defined.", "name");
            throw new IllegalArgumentException(errorMessage);
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    @Parameter(required=false, defaultValue="false", description="Flag whether to remove backticks from the keys.")
    public void setRemoveBackticks(Boolean removeBackticks) {
        this._removeBackticks = removeBackticks;
    }

    public Boolean isRemoveBackticks() {
        return this._removeBackticks;
    }

    @Parameter(required=false, defaultValue="", description="If this parameter is set we assume that events input to this query are of a Map type.")
    public void setInputType(String inputType) {
        this._inputType = inputType == null || inputType.trim().isEmpty() ? null : inputType.trim();
    }

    public String getInputType() {
        return this._inputType;
    }

    @Parameter(defaultValue="false", name="forward-input", description="Flag that inicates whether a data item should be forwarded to later processors. ")
    public void setForward(Boolean forward) {
        this._forward = forward;
    }

    public boolean isForward() {
        return this._forward;
    }

    public void configure(Element document) {
        String body = document.getTextContent();
        log.info("Configuring 'streams.esper.Query' element. Body content is:\n{}", (Object)body);
        if (body != null) {
            this.setQuery(new BodyContent(body));
        }
    }
}

