/*
 *  streams library
 *
 *  Copyright (C) 2011-2014 by Christian Bockermann, Hendrik Blom
 * 
 *  streams is a library, API and runtime environment for processing high
 *  volume data streams. It is composed of three submodules "stream-api",
 *  "stream-core" and "stream-runtime".
 *
 *  The streams library (and its submodules) is free software: you can 
 *  redistribute it and/or modify it under the terms of the 
 *  GNU Affero General Public License as published by the Free Software 
 *  Foundation, either version 3 of the License, or (at your option) any 
 *  later version.
 *
 *  The stream.ai library (and its submodules) is distributed in the hope
 *  that it will be useful, but WITHOUT ANY WARRANTY; without even the implied 
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see http://www.gnu.org/licenses/.
 */
package stream.runtime;

import stream.io.Source;

/**
 * This interface marks a consumer of a data-stream. The consumer provides the
 * data-stream name as String (<code>getInput()</code>) and a setter to have the
 * data-stream injected.
 * 
 * @author Christian Bockermann &lt;christian.bockermann@udo.edu&gt;
 * 
 */
public interface DataStreamConsumer {

	/**
	 * Returns the name of the data-stream the implementing instance want to
	 * consume.
	 * 
	 * @return
	 */
	public String getInput();

	/**
	 * Sets the data-stream of this consumer.
	 * 
	 * @param stream
	 */
	public void setSource(Source stream);

	/**
	 * Returns the data-stream assigned to this consumer.
	 * 
	 * @return
	 */
	public Source getSource();
}
