/*
 * Decompiled with CFR 0.152.
 */
package stream.doc.helper;

import java.io.PrintStream;
import java.util.Map;
import stream.annotations.Parameter;
import stream.data.WithKeys;
import stream.doc.helper.ParameterTableWriter;
import stream.flow.Delay;
import stream.runtime.setup.ParameterDiscovery;

public class MarkdownParameterTable
implements ParameterTableWriter {
    @Override
    public void writeParameterTable(Class<?> clazz, PrintStream out) {
        out.println("<table>");
        out.println("<tr>");
        out.println("<th>Parameter</th><th>Type</th><th>Description</th><th>Required</th>");
        out.println("</tr>");
        Map<String, Class<?>> tmp = ParameterDiscovery.discoverParameters(clazz);
        for (String key : tmp.keySet()) {
            out.println("<tr>");
            Parameter p = ParameterDiscovery.getParameterAnnotation(clazz, key);
            if (p != null) {
                String name = key;
                if (p.name() != null && !p.name().trim().isEmpty()) {
                    name = p.name();
                }
                out.println("<td>" + name + "</td>");
                out.println("<td>" + p.description() + "</td>");
                out.println("<td>" + p.required() + "</td>");
            } else {
                out.println("<td>" + key + "</td>");
                out.println("<td></td>");
                out.println("<td>?</td>");
            }
            out.println("</tr>");
        }
        out.println("</table>");
    }

    public static void main(String[] args) throws Exception {
        MarkdownParameterTable table = new MarkdownParameterTable();
        table.writeParameterTable(WithKeys.class, System.out);
        table.writeParameterTable(Delay.class, System.out);
    }
}

