/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Context;
import stream.runtime.ApplicationContext;
import stream.runtime.DefaultNamingService;
import stream.service.NamingService;
import stream.service.Service;
import stream.service.ServiceInfo;

public class ContainerContext
implements ApplicationContext {
    static final String CONTEXT_NAME = "container";
    static Logger log = LoggerFactory.getLogger(ContainerContext.class);
    final Map<String, String> properties = new LinkedHashMap<String, String>();
    NamingService namingService;
    String name;
    final String id;
    final Map<String, NamingService> remoteContainers = new LinkedHashMap<String, NamingService>();

    public ContainerContext(String id) {
        this(id, new DefaultNamingService());
    }

    public ContainerContext(String id, NamingService ns) {
        this(id, "local", ns);
    }

    public ContainerContext(String id, String name, NamingService ns) {
        this.id = id;
        this.namingService = ns;
        log.debug("Creating experiment-context '{}'", (Object)name);
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public NamingService getNamingService() {
        return this.namingService;
    }

    public void setNamingService(NamingService namingService) {
        this.namingService = namingService;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperty(String key, String value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    public Object resolve(String variable) {
        String key;
        if ("application.id".equals(variable) || "id".equals(variable)) {
            return this.id;
        }
        if (variable == null) {
            return null;
        }
        String var = variable.trim();
        if (var.startsWith("container.") && this.properties.containsKey(key = var.substring(CONTEXT_NAME.length() + 1))) {
            return this.properties.get(key);
        }
        return null;
    }

    public <T extends Service> T lookup(String ref, Class<T> serviceClass) throws Exception {
        return (T)this.namingService.lookup(ref, serviceClass);
    }

    public void register(String ref, Service p) throws Exception {
        this.namingService.register(ref, p);
    }

    public void unregister(String ref) throws Exception {
        this.namingService.unregister(ref);
    }

    public Map<String, ServiceInfo> list() throws Exception {
        return this.namingService.list();
    }

    public void addContainer(String key, NamingService remoteNamingService) throws Exception {
        log.info("Adding remote container '{}' at {}", (Object)key, (Object)remoteNamingService);
        this.namingService.addContainer(key, remoteNamingService);
    }

    public boolean contains(String key) {
        if (key.startsWith("container.")) {
            key = key.substring(CONTEXT_NAME.length() + 1);
            return this.properties.containsKey(key);
        }
        if (key.startsWith("application.")) {
            key = key.substring("application.".length());
            return this.properties.containsKey("key");
        }
        return false;
    }

    public Context getParent() {
        return null;
    }

    public String path() {
        return "application:" + this.getId();
    }
}

