/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.LinkedHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.Container;

public class Containers
extends LinkedHashMap<String, Container> {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(Containers.class);
    ExecutorService pool;

    public Containers() {
        this.pool = Executors.newCachedThreadPool();
    }

    public Containers(int n) {
        this.pool = Executors.newFixedThreadPool(n);
    }

    public Future<Boolean> start(String name) {
        Container c = (Container)this.get(name);
        if (c == null) {
            return null;
        }
        Future<Boolean> f = this.pool.submit(c);
        return f;
    }

    public boolean shutdown(String name) {
        Container c = (Container)this.get(name);
        if (c == null) {
            return false;
        }
        c.shutdown();
        return true;
    }

    public boolean shutdown() {
        int c;
        this.pool.shutdown();
        try {
            for (c = 0; c < 10 && !this.pool.awaitTermination(10L, TimeUnit.SECONDS); ++c) {
                this.log.info("Awaiting completion of threads.");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (c == 10) {
            this.log.info("Can't stop pool. Killed...");
            this.pool.shutdownNow();
            return false;
        }
        return true;
    }
}

