/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.ApplicationContext;
import stream.runtime.LifeCycle;
import streams.runtime.Hook;

public class LifeCycleManager
implements Hook {
    static Logger log = LoggerFactory.getLogger(LifeCycleManager.class);
    List<LifeCycle> lifeCycles = new ArrayList<LifeCycle>();

    public void register(LifeCycle obj) {
        if (this.lifeCycles.contains(obj)) {
            // empty if block
        }
    }

    public void initAll(ApplicationContext context) throws Exception {
        for (LifeCycle obj : this.lifeCycles) {
            obj.init(context);
        }
    }

    public void finishAll() {
        for (LifeCycle obj : this.lifeCycles) {
            try {
                obj.finish();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void signal(int flags) {
        if (flags == 0) {
            this.finishAll();
        }
    }
}

