/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.runtime.setup.UserSettings;
import stream.util.Variables;

public class StreamRuntime {
    static Logger log = LoggerFactory.getLogger(StreamRuntime.class);
    public static final UserSettings userSettings = new UserSettings();
    private static boolean loggingSetup = false;
    public static String[] logSearchPath = new String[]{"", userSettings.getStreamsDirectory().getAbsolutePath()};

    public static void setupLogging() {
        if (loggingSetup) {
            return;
        }
        loggingSetup = true;
        ArrayList<String> searchPaths = new ArrayList<String>();
        if (System.getenv("STREAMS_HOME") != null) {
            searchPaths.add(System.getenv("STREAMS_HOME") + File.separator + "conf");
        }
        for (String path : logSearchPath) {
            searchPaths.add(path);
        }
        for (String path : searchPaths) {
            String p = path;
            p = !p.isEmpty() ? path + File.separator + "log4j.properties" : "log4j.properties";
            File logProp = new File(p);
            if (!logProp.canRead()) continue;
            System.err.println("Using log settings from " + logProp.getAbsolutePath());
            try {
                Class<?> configurator = Class.forName("org.apache.log4j.PropertyConfigurator");
                Method configure = configurator.getMethod("configure", String.class);
                configure.invoke(null, logProp.getAbsolutePath());
                break;
            }
            catch (Exception e) {
                System.err.println("Failed to setup logging with log4j.properties: " + e.getMessage());
            }
        }
    }

    public static Variables loadUserProperties() {
        Variables vars = new Variables();
        ArrayList<String> propFiles = new ArrayList<String>();
        propFiles.add(System.getProperty("user.home") + File.separator + ".streams.properties");
        propFiles.add(new File("streams.properties").getAbsolutePath());
        if (System.getProperty("streams.properties") != null) {
            String ps = System.getProperty("streams.properties");
            String[] locs = new String[]{ps};
            if (ps.indexOf(",") >= 0) {
                locs = ps.split(",");
            }
            log.debug("Ignoring default properties, reading only from {}", (Object)System.getProperty("streams.properties"));
            propFiles.clear();
            for (String loc : locs) {
                propFiles.add(loc.trim());
            }
        }
        for (String location : propFiles) {
            File f = new File(location);
            if (!f.canRead()) continue;
            log.debug("Reading properties from {}", (Object)f);
            try {
                Properties p = new Properties();
                p.load(new FileInputStream(f));
                for (Object k : p.keySet()) {
                    log.debug("Adding property '{}' = '{}'", k, (Object)p.getProperty(k.toString()));
                    vars.set(k.toString(), p.getProperty(k.toString()));
                }
            }
            catch (Exception e) {
                log.error("Failed to read properties from {}: {}", (Object)f, (Object)e.getMessage());
            }
        }
        return vars;
    }
}

