/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.annotations.BodyContent;
import stream.annotations.Parameter;
import stream.annotations.ParameterException;
import stream.expressions.Condition;
import stream.io.Sink;
import stream.runtime.DependencyInjection;
import stream.runtime.setup.ParameterDiscovery;
import stream.runtime.setup.ParameterFieldInjection;
import stream.runtime.setup.ParameterMethodInjection;
import stream.runtime.setup.ParameterValidator;
import stream.util.Variables;

public class ParameterInjection {
    static Logger log = LoggerFactory.getLogger(ParameterInjection.class);

    public static Set<String> inject(Object o, Map<String, ?> params, Variables variableContext) throws Exception {
        log.debug("Injecting parameters {} into object {}", params, o);
        ParameterValidator.checkClassParameters(o.getClass(), params);
        HashSet<String> alreadySet = new HashSet<String>();
        alreadySet.addAll(new ParameterFieldInjection().inject(o, params, variableContext));
        alreadySet.addAll(new ParameterMethodInjection().inject(o, params, variableContext));
        Set<String> keys = params.keySet();
        keys.removeAll(alreadySet);
        if (!keys.isEmpty()) {
            log.debug("Missing parameters to be injected: {}", keys);
        }
        ParameterInjection.checkForMissingParametersAndSetters(o, params, alreadySet);
        return alreadySet;
    }

    private static void checkForMissingParametersAndSetters(Object o, Map<String, ?> params, Set<String> skip) throws ParameterException {
        if (!"false".equalsIgnoreCase(System.getProperty("parameter.validate.setter"))) {
            for (AccessibleObject accessibleObject : o.getClass().getMethods()) {
                Parameter pa;
                String name;
                if (!ParameterDiscovery.isSetter((Method)accessibleObject) || skip.contains(name = ParameterDiscovery.getParameterName((Method)accessibleObject)) || (pa = ((Method)accessibleObject).getAnnotation(Parameter.class)) == null || !pa.required() || params.containsKey(name)) continue;
                throw new ParameterException("Required parameter '" + name + "' for class '" + o.getClass() + "' not provided by configuration!");
            }
        } else {
            log.debug("Validation of method annotations disabled.");
        }
        if (!"false".equalsIgnoreCase(System.getProperty("parameter.validate.fields"))) {
            for (AccessibleObject accessibleObject : o.getClass().getDeclaredFields()) {
                boolean xmlHasParameter;
                if (!accessibleObject.isAnnotationPresent(Parameter.class)) continue;
                Parameter p = ((Field)accessibleObject).getAnnotation(Parameter.class);
                log.debug("Has Parameter annotation " + ((Field)accessibleObject).toString());
                boolean required = p.required();
                String xmlName = p.name();
                if (xmlName == null || xmlName.isEmpty()) {
                    xmlName = ((Field)accessibleObject).getName();
                }
                if (skip.contains(xmlName) || !required) continue;
                boolean bl = xmlHasParameter = params.containsKey(xmlName) && params.get(xmlName) != null;
                if (xmlHasParameter) continue;
                throw new ParameterException("XML is missing parameter '" + xmlName + "' for field '" + ((Field)accessibleObject).getName() + "' in processor " + o.getClass().getSimpleName());
            }
        } else {
            log.debug("Field validation disabled!");
        }
    }

    public static void injectSystemProperties(Object object, String prefix) throws Exception {
        Map<String, String> params = ParameterDiscovery.getSystemProperties(prefix);
        ParameterInjection.inject(object, params, new Variables());
    }

    public static Map<String, String> extract(Object learner) throws Exception {
        TreeMap<String, String> params = new TreeMap<String, String>();
        for (Method m : learner.getClass().getMethods()) {
            String name = m.getName();
            if (!name.startsWith("get") || m.getParameterTypes().length != 0) continue;
            log.debug("Found getter '{}' for class '{}'", (Object)name, learner.getClass());
            Class<?> rt = m.getReturnType();
            if (!ParameterInjection.isTypeSupported(rt)) continue;
            Object val = m.invoke(learner, new Object[0]);
            String key = ParameterDiscovery.getParameterName(m);
            if (key == null || val == null) continue;
            if (val.getClass().isArray()) {
                int len = Array.getLength(val);
                StringBuffer s = new StringBuffer();
                for (int i = 0; i < len; ++i) {
                    s.append(Array.get(val, i) + "");
                    if (i + 1 >= len) continue;
                    s.append(",");
                }
                params.put(key, s.toString());
                continue;
            }
            params.put(key, "" + val);
        }
        return params;
    }

    public static boolean isGetter(Method m) {
        return ParameterDiscovery.isGetter(m);
    }

    public static boolean hasGetter(Class<?> clazz, String name) {
        try {
            for (Method m : clazz.getMethods()) {
                if (!ParameterInjection.isGetter(m) || !m.getName().equalsIgnoreCase("get" + name)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isTypeSupported(Class<?> clazz) {
        if (DependencyInjection.isServiceImplementation(clazz)) {
            return false;
        }
        if (clazz.isArray() && ParameterInjection.isNativeType(clazz.getComponentType())) {
            return true;
        }
        if (clazz.equals(String.class) || clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Double.class) || clazz.equals(Boolean.class) || clazz.equals(File.class) || clazz.equals(BodyContent.class) || clazz.equals(Boolean.TYPE) || clazz.equals(Integer.TYPE) || clazz.isPrimitive() || clazz.equals(Condition.class) || clazz.equals(Map.class)) {
            return true;
        }
        return clazz.isPrimitive();
    }

    public static boolean isNativeType(Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(Long.class) || clazz.equals(Integer.class) || clazz.equals(Double.class) || clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE);
    }

    public static boolean isQueueSetter(Method m) {
        if (!m.getName().toLowerCase().startsWith("set")) {
            log.trace("Not a setter -> method not starting with 'set'");
            return false;
        }
        Class<?>[] types = m.getParameterTypes();
        if (types.length != 1) {
            log.trace("Not a setter, parameter types: {}", (Object[])types);
            return false;
        }
        Class<?> type = types[0];
        if (!type.isArray()) {
            if (Sink.class.isAssignableFrom(type)) {
                log.debug("Found setter for type '{}': {}", Sink.class, (Object)m);
                return true;
            }
        } else {
            Class<?> ct = type.getComponentType();
            if (ct != null && Sink.class.isAssignableFrom(ct)) {
                log.debug("Found setter for array-type '{}': {}", Sink.class, (Object)m);
                return true;
            }
        }
        return false;
    }

    public static boolean isQueueArraySetter(Method m) {
        Class<?> type = m.getParameterTypes()[0];
        return type.isArray();
    }
}

