/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFinder {
    static Logger log = LoggerFactory.getLogger(ResourceFinder.class);
    public static final Condition isMarkdown = new Condition(){

        @Override
        public boolean matches(String path) {
            return path != null && path.toLowerCase().endsWith(".md");
        }
    };

    public static String[] getResource(Condition c) throws Exception {
        return ResourceFinder.getResources("", c);
    }

    public static String[] getResources(String packageName, Condition cond) throws ClassNotFoundException, IOException {
        ArrayList<String> classes = new ArrayList<String>();
        ClassLoader classLoader = ResourceFinder.class.getClassLoader();
        assert (classLoader != null);
        String path = packageName;
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if (resource.toString().startsWith("jar:")) {
                log.info("Scanning jar-file {}", (Object)resource.getPath());
                String p = resource.getPath();
                if (p.indexOf("!") <= 0) continue;
                p = p.substring(0, p.indexOf("!"));
                log.info("Opening jar '{}'", (Object)p);
                if (p.startsWith("file:")) {
                    p = p.substring("file:".length());
                }
                classes.addAll(ResourceFinder.findResources(new JarFile(p), packageName, cond));
                continue;
            }
            log.trace("Checking URL {}", (Object)resource);
            dirs.add(new File(resource.getFile()));
        }
        for (File directory : dirs) {
            classes.addAll(ResourceFinder.findResources(directory, packageName, cond));
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static List<String> findResources(JarFile jar, String packageName, Condition cond) throws ClassNotFoundException {
        ArrayList<String> classes = new ArrayList<String>();
        log.trace("Checking jar-file {}", (Object)jar.getName());
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            entry.getName();
            log.trace("Checking JarEntry '{}'", (Object)entry.getName());
            if (!cond.matches(entry.getName())) continue;
            try {
                log.trace("Adding entry {}", (Object)entry);
                classes.add(entry.getName());
            }
            catch (Exception e) {
                log.error("Failed to load class for entry '{}'", (Object)entry.getName());
            }
        }
        return classes;
    }

    private static List<String> findResources(File directory, String packageName, Condition cond) throws ClassNotFoundException {
        File[] files;
        log.trace("Searching directory '{}' for package '{}'", (Object)directory, (Object)packageName);
        ArrayList<String> classes = new ArrayList<String>();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                classes.addAll(ResourceFinder.findResources(file, packageName + "/" + file.getName(), cond));
                continue;
            }
            if (!cond.matches(packageName + "/" + file.getName())) continue;
            try {
                log.trace("Adding entry '{}' (package is: {})", (Object)file.getAbsolutePath(), (Object)directory);
                classes.add(packageName + "/" + file.getName());
            }
            catch (Exception e) {
                log.error("Failed to add class: {}", (Object)e.getMessage());
            }
        }
        return classes;
    }

    public static interface Condition {
        public boolean matches(String var1);
    }
}

