/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Processor;
import stream.annotations.Service;
import stream.runtime.DependencyInjection;
import streams.application.ComputeGraph;

public class ServiceFieldInjection {
    static Logger log = LoggerFactory.getLogger(ServiceFieldInjection.class);

    public List<ComputeGraph.ServiceRef> getServiceRefsForFields(Processor p, Map<String, String> params) {
        ArrayList<ComputeGraph.ServiceRef> refs = new ArrayList<ComputeGraph.ServiceRef>();
        for (Field field : p.getClass().getDeclaredFields()) {
            if (!DependencyInjection.isServiceImplementation(field.getType())) continue;
            String property = field.getName();
            Class<?> type = field.getType();
            Service info = field.getAnnotation(Service.class);
            if (info != null && !info.name().isEmpty()) {
                property = info.name();
                log.debug("Using property '{}' from @Service annotation", (Object)info.name());
            } else {
                log.debug("Using property '{}' derived from field name", (Object)field.getName());
            }
            if (DependencyInjection.hasServiceSetter(property, p) != null) {
                log.debug("A service-setter method for '" + property + "' exists, skipping field-injection for this service field.");
                continue;
            }
            String refStr = params.get(property);
            if (refStr == null) {
                Service serviceAnnotation = field.getAnnotation(Service.class);
                if (serviceAnnotation != null && !serviceAnnotation.required()) {
                    String name = serviceAnnotation.name();
                    if (name == null || name.isEmpty()) {
                        name = field.getName();
                    }
                    log.warn("No service injected for optional service field '{}'", (Object)name);
                    continue;
                }
                throw new RuntimeException("Found service field for '" + field.getName() + "', but related XML attribute '" + property + "' is not provided!");
            }
            refs.add(new ComputeGraph.ServiceRef((Object)p, property, refStr.split(","), type));
        }
        return refs;
    }
}

