/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.setup.factory;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import stream.io.SourceURL;
import stream.io.Stream;
import stream.io.multi.MultiStream;
import stream.runtime.ProcessContainer;
import stream.runtime.setup.ParameterInjection;
import stream.runtime.setup.factory.ObjectFactory;
import stream.util.Variables;

public class StreamFactory {
    static Logger log = LoggerFactory.getLogger(StreamFactory.class);
    static final Map<String, String> streamClassesByExtension = new LinkedHashMap<String, String>();

    public static Stream createStream(ObjectFactory objectFactory, Element node, Variables local) throws Exception {
        Stream stream;
        Constructor<?> constr;
        Map params = objectFactory.getAttributes(node);
        Class<?> clazz = Class.forName(local.expand(params.get("class")));
        String urlParam = params.get("url");
        if (urlParam == null || clazz == null) {
            // empty if block
        }
        if (urlParam != null) {
            constr = clazz.getConstructor(SourceURL.class);
            SourceURL url = null;
            String urlString = params.get("url");
            if ((urlString = local.expand(urlString)).startsWith("classpath:")) {
                String resource = urlString.substring("classpath:".length());
                log.debug("Looking up resource '{}'", (Object)resource);
                URL u = ProcessContainer.class.getResource(resource);
                if (u == null) {
                    throw new Exception("Classpath url does not exist! Resource '" + resource + "' not found!");
                }
                url = new SourceURL(u);
            } else {
                url = new SourceURL(urlString);
            }
            stream = (Stream)constr.newInstance(url);
        } else {
            constr = clazz.getConstructor(new Class[0]);
            stream = (Stream)constr.newInstance(new Object[0]);
        }
        params = local.expandAll(params);
        log.debug("Injecting variables {} into stream {}", (Object)params, (Object)stream);
        ParameterInjection.inject(stream, params, local);
        if (stream instanceof MultiStream) {
            MultiStream multiStream = (MultiStream)stream;
            log.debug("Found a multi-stream, need to add inner streams...");
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node inner = nodes.item(i);
                if (inner.getNodeType() != 1) continue;
                Element child = (Element)inner;
                if (child.getNodeName().equalsIgnoreCase("stream") || child.getNodeName().equalsIgnoreCase("datastream")) {
                    Stream innerStream = StreamFactory.createStream(objectFactory, child, local);
                    log.debug("Created inner stream {}", (Object)innerStream);
                    String id = child.getAttribute("id");
                    if (id == null || "".equals(id.trim())) {
                        id = innerStream.toString();
                    }
                    multiStream.addStream(id, innerStream);
                    continue;
                }
                throw new Exception("Pre-processors within streams are no longer supported!");
            }
            stream = multiStream;
        }
        return stream;
    }

    public static Class<?> guessStreamFormat(String url) throws Exception {
        int idx;
        log.debug("Trying to derive stream class from URL '{}'", (Object)url);
        String u = url.toLowerCase();
        boolean gz = u.endsWith(".gz");
        String ext = null;
        if (gz) {
            u = u.replaceAll("\\.gz$", "");
        }
        if ((idx = u.lastIndexOf(".")) > 0) {
            ext = u.substring(idx + 1);
            log.debug("Extension of URL is '{}'", (Object)ext);
            String className = streamClassesByExtension.get(ext);
            if (className != null) {
                return Class.forName(className);
            }
        }
        return null;
    }

    static {
        streamClassesByExtension.put("csv", "stream.io.CsvStream");
        streamClassesByExtension.put("txt", "stream.io.LineStream");
        streamClassesByExtension.put("svmlight", "stream.io.SvmLightStream");
        streamClassesByExtension.put("json", "stream.io.JSONStream");
        streamClassesByExtension.put("arff", "stream.io.ArffStream");
    }
}

