/*
 * Decompiled with CFR 0.152.
 */
package stream.runtime.shutdown;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Process;
import stream.Processor;
import stream.io.Source;
import stream.runtime.AbstractProcess;
import stream.runtime.Monitor;
import stream.runtime.shutdown.AbstractShutdownCondition;
import stream.utils.XMLFormatter;
import streams.application.ComputeGraph;

public class LocalShutdownCondition
extends AbstractShutdownCondition {
    static Logger log = LoggerFactory.getLogger(LocalShutdownCondition.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMet(ComputeGraph graph) {
        log.debug("Checking if shutdown condition is met...");
        ComputeGraph computeGraph = graph;
        synchronized (computeGraph) {
            if (graph.nodes().isEmpty()) {
                return true;
            }
            ArrayList<Monitor> monitors = new ArrayList<Monitor>();
            int processes = 0;
            int monitorCount = 0;
            for (Object node : graph.nodes()) {
                if (node instanceof Monitor) {
                    monitors.add((Monitor)node);
                    ++monitorCount;
                    continue;
                }
                if (!(node instanceof Process) || node instanceof Monitor) continue;
                ++processes;
            }
            if (processes == 0) {
                log.debug("No more processes running...");
                return true;
            }
            if (processes == 0 && monitorCount == 0) {
                log.debug("All monitors, all processes have finished!");
                return true;
            }
            int hangon = 0;
            log.debug("config:\n{}", (Object)XMLFormatter.createXMLString(graph));
            for (Object node : graph.nodes()) {
                if (node instanceof Source || node instanceof Monitor || !(node instanceof Processor) || node instanceof AbstractProcess) continue;
                ++hangon;
            }
            if (hangon > 0) {
                return false;
            }
            log.debug("shutdown-condition fulfilled!");
            return true;
        }
    }
}

