/*
 * Decompiled with CFR 0.152.
 */
package yahoofinance.quotes.query1v7;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yahoofinance.Utils;
import yahoofinance.YahooFinance;
import yahoofinance.histquotes2.CrumbManager;
import yahoofinance.util.RedirectableRequest;

public abstract class QuotesRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(QuotesRequest.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    protected final String symbols;

    public QuotesRequest(String symbols) {
        this.symbols = symbols;
    }

    public String getSymbols() {
        return this.symbols;
    }

    protected abstract T parseJson(JsonNode var1);

    public T getSingleResult() throws IOException {
        List<T> results = this.getResult();
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public List<T> getResult() throws IOException {
        ArrayList<T> result;
        block8: {
            result = new ArrayList<T>();
            LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
            params.put("symbols", this.symbols);
            String url = YahooFinance.QUOTES_QUERY1V7_BASE_URL + "?" + Utils.getURLParameters(params);
            if (!CrumbManager.getCrumb().isEmpty()) {
                url = url + "&crumb=" + CrumbManager.getCrumb();
            }
            log.info("Sending request: {}", (Object)url);
            URL request = new URL(url);
            RedirectableRequest redirectableRequest = new RedirectableRequest(request, 5);
            redirectableRequest.setConnectTimeout(YahooFinance.CONNECTION_TIMEOUT);
            redirectableRequest.setReadTimeout(YahooFinance.CONNECTION_TIMEOUT);
            URLConnection connection = redirectableRequest.openConnection();
            try (InputStreamReader is = new InputStreamReader(connection.getInputStream());){
                JsonNode node = objectMapper.readTree((Reader)is);
                if (node.has("quoteResponse") && node.get("quoteResponse").has("result")) {
                    node = node.get("quoteResponse").get("result");
                    for (int i = 0; i < node.size(); ++i) {
                        result.add(this.parseJson(node.get(i)));
                    }
                    break block8;
                }
                throw new IOException("Invalid response");
            }
        }
        return result;
    }
}

