/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax;

import de.sfuhrm.htmltosax.parser.html.HtmlDFA;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

class HtmlToSaxReader
implements XMLReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlToSaxReader.class);
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;

    HtmlToSaxReader() {
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        BufferedReader br;
        InputStreamReader isr;
        InputStream is;
        HtmlDFA htmlDfa = null;
        Reader r = input.getCharacterStream();
        if (htmlDfa == null && r != null) {
            LOGGER.debug("Got reader for InputSource");
            BufferedReader br2 = new BufferedReader(r);
            htmlDfa = new HtmlDFA(br2);
        }
        if (htmlDfa == null && input.getEncoding() != null && (is = input.getByteStream()) != null) {
            LOGGER.debug("Got InputStream with encoding {} for InputSource", (Object)input.getEncoding());
            isr = new InputStreamReader(is, input.getEncoding());
            br = new BufferedReader(isr);
            htmlDfa = new HtmlDFA(br);
        }
        if (htmlDfa == null && (is = input.getByteStream()) != null) {
            LOGGER.warn("Got InputStream with default encoding ISO-8859-1 for InputSource");
            isr = new InputStreamReader(is, "ISO-8859-1");
            br = new BufferedReader(isr);
            htmlDfa = new HtmlDFA(br);
        }
        if (htmlDfa == null) {
            throw new SAXException("Failed to init the HtmlToSax driver");
        }
        htmlDfa.setContentHandler(this.getContentHandler());
        htmlDfa.setErrorHandler(this.getErrorHandler());
        this.getContentHandler().startDocument();
        htmlDfa.parse();
        this.getContentHandler().endDocument();
        if (htmlDfa == null) {
            throw new SAXException("Could not initialize input");
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

