/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Sample
extends DefaultHandler {
    private List<String> hrefs = new ArrayList<String>();
    private static final boolean showErrors = true;

    Sample() {
    }

    public List<String> getHRefs() {
        return this.hrefs;
    }

    private void eventuallyShowError(SAXParseException e) {
        e.printStackTrace();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.eventuallyShowError(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.eventuallyShowError(e);
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.eventuallyShowError(e);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        int len = attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String qname = attributes.getQName(i);
            if (!qname.equalsIgnoreCase("src") && !qname.equalsIgnoreCase("href")) continue;
            System.out.println(this.hrefs.size() + ":" + attributes.getValue(i));
            this.hrefs.add(attributes.getValue(i));
        }
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        if (args.length == 0) {
            System.err.println("Please add an URL to your argument list!");
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance("de.sfuhrm.htmltosax.HtmlToSaxParserFactory", null);
        SAXParser parser = factory.newSAXParser();
        Sample s = new Sample();
        parser.parse(new InputSource(new URL(args[0]).openStream()), (DefaultHandler)s);
        System.out.println("Extracted links: ");
        List<String> hrefs = s.getHRefs();
        for (int i = 0; i < hrefs.size(); ++i) {
            System.out.println(i + 1 + ". " + hrefs.get(i));
        }
    }
}

