/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax.parser.dfa;

import de.sfuhrm.htmltosax.parser.dfa.State;
import de.sfuhrm.htmltosax.parser.dfa.Transition;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DFA {
    private static final Logger LOGGER = LoggerFactory.getLogger(DFA.class);
    private final Reader in;
    private int line;
    private int column;
    private State initialState;
    private Map<State, StateCharMap> stateCharMaps;
    private State forcedState;

    protected DFA(Reader reader, State init) {
        if (reader == null) {
            throw new NullPointerException("Reader is null");
        }
        if (init == null) {
            throw new NullPointerException("State is null");
        }
        this.in = reader;
        this.line = 1;
        this.column = 1;
        this.initialState = init;
    }

    protected DFA(Reader reader, State init, Transition[] transitions) {
        this(reader, init);
        if (transitions == null) {
            throw new NullPointerException("transitions is null");
        }
        this.init(transitions);
        this.line = 1;
        this.column = 1;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    protected final void init(Transition[] transitions) {
        HashMap<State, ArrayList<Transition>> fromMap = new HashMap<State, ArrayList<Transition>>();
        for (Transition trans : transitions) {
            ArrayList<Transition> list = (ArrayList<Transition>)fromMap.get(trans.from());
            if (list == null) {
                list = new ArrayList<Transition>();
                fromMap.put(trans.from(), list);
            }
            list.add(trans);
        }
        this.stateCharMaps = new HashMap<State, StateCharMap>();
        for (Map.Entry entry : fromMap.entrySet()) {
            char hi = DFA.highestChar((Collection)entry.getValue());
            Transition[] ts = new Transition[hi + '\u0001'];
            Transition defaultTrans = null;
            Transition eofTrans = null;
            for (Transition t : (List)entry.getValue()) {
                if (t.chars() == null) {
                    defaultTrans = t;
                    continue;
                }
                if (t.chars().isEmpty()) {
                    eofTrans = t;
                    continue;
                }
                for (int i = 0; i < t.chars().length(); ++i) {
                    Transition old = ts[t.chars().charAt(i)];
                    if (old != null) {
                        throw new IllegalStateException("Overwriting transition " + old);
                    }
                    ts[t.chars().charAt((int)i)] = t;
                }
            }
            StateCharMap scm = new StateCharMap((State)entry.getKey(), defaultTrans, eofTrans, ts);
            this.stateCharMaps.put(scm.state, scm);
        }
    }

    private static char highestChar(Collection<Transition> trans) {
        char hi = '\u0000';
        for (Transition t : trans) {
            char cur;
            if (t.chars() == null || (cur = DFA.highestChar(t.chars())) <= hi) continue;
            hi = cur;
        }
        return hi;
    }

    private static char highestChar(String s) {
        char hi = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c <= hi) continue;
            hi = c;
        }
        return hi;
    }

    public long byteSize() {
        long bs = 0L;
        for (StateCharMap scm : this.stateCharMaps.values()) {
            bs += scm.byteSize();
        }
        return bs;
    }

    protected void leftState(State s, StringBuilder sb) {
    }

    protected void enteredState(State s, StringBuilder sb) {
    }

    protected String pos() {
        return "l" + this.line() + "c" + this.column();
    }

    protected void forceTo(State state) {
        this.forcedState = state;
    }

    public void parse() throws IOException {
        int intValue;
        State state = this.initialState;
        StateCharMap scm = this.stateCharMaps.get(state);
        StringBuilder sb = new StringBuilder();
        this.enteredState(state, sb);
        while ((intValue = this.in.read()) != -1) {
            char charValue = (char)intValue;
            if (charValue == '\n') {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            Transition transition = scm.getFor(charValue);
            sb.append(charValue);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{}:{}, Char={}, Buffer: {}", new Object[]{this.pos(), state, Character.valueOf(charValue), sb});
            }
            if (transition == null) continue;
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{}:{}, Match: {}, to: {}", new Object[]{this.pos(), state, Character.valueOf(charValue), transition.to()});
                }
                transition.fire(this, sb);
                if (transition.from() != transition.to()) {
                    this.leftState(state, sb);
                    this.enteredState(transition.to(), sb);
                }
                state = transition.to();
                State myForced = this.forcedState;
                if (myForced != null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Forced to state {} when state {} would be the transitions choice", new Object[]{myForced, state});
                    }
                    state = myForced;
                    this.forcedState = null;
                }
                if ((scm = this.stateCharMaps.get(state)) != null) continue;
                throw new IllegalStateException("SCM for " + state + " not found");
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
        if (scm.getEofTransition() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing EOF transition");
            }
            try {
                scm.getEofTransition().fire(this, sb);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    static class StateCharMap {
        private final State state;
        private final Transition[] transitions;
        private final Transition defaultTransition;
        private final Transition eofTransition;

        StateCharMap(State state, Transition defaultTransition, Transition eofTransition, Transition[] transitions) {
            if (state == null) {
                throw new NullPointerException("state is null");
            }
            this.state = state;
            this.defaultTransition = defaultTransition;
            this.eofTransition = eofTransition;
            if (transitions == null) {
                throw new NullPointerException("transitions is null");
            }
            this.transitions = transitions;
        }

        public Transition getFor(char c) {
            Transition tableValue;
            Transition result = this.defaultTransition;
            if (this.transitions.length > c && (tableValue = this.transitions[c]) != null) {
                result = tableValue;
            }
            return result;
        }

        public Transition getEofTransition() {
            return this.eofTransition;
        }

        public long byteSize() {
            return this.transitions.length * 4;
        }

        public int size() {
            return this.transitions.length;
        }
    }
}

