/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax.parser.dfa;

import de.sfuhrm.htmltosax.parser.dfa.Action;
import de.sfuhrm.htmltosax.parser.dfa.DFA;
import de.sfuhrm.htmltosax.parser.dfa.State;

public final class Transition<T extends DFA> {
    private final State fromState;
    private final String chars;
    private final State toState;
    private final Action<T>[] actions;
    static final Action NullAction = new Action(){

        public void fire(DFA dfa, Transition transition, StringBuilder in) throws Exception {
        }
    };
    public static final Action ClearAction = new Action(){

        public void fire(DFA dfa, Transition transition, StringBuilder in) throws Exception {
            in.setLength(0);
        }
    };
    public static final Action DeleteLastAction = new Action(){

        public void fire(DFA dfa, Transition transition, StringBuilder in) throws Exception {
            in.setLength(in.length() - 1);
        }
    };

    public Transition(State from, String chars, State to, Action ... actions) {
        if (from == null) {
            throw new NullPointerException("from state is null");
        }
        this.fromState = from;
        this.chars = chars;
        if (to == null) {
            throw new NullPointerException("to state is null");
        }
        this.toState = to;
        if (actions == null) {
            throw new NullPointerException("actions is null");
        }
        this.actions = actions;
    }

    public State from() {
        return this.fromState;
    }

    public State to() {
        return this.toState;
    }

    public String chars() {
        return this.chars;
    }

    void fire(T dfa, StringBuilder cs) throws Exception {
        for (int i = 0; i < this.actions.length; ++i) {
            this.actions[i].fire(dfa, this, cs);
        }
    }

    public String toString() {
        return this.from() + "->" + this.to() + this.chars() != null ? " \"" + this.chars() + "\"" : " <<default>>";
    }
}

