/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax.parser.html;

import de.sfuhrm.htmltosax.parser.dfa.Action;
import de.sfuhrm.htmltosax.parser.dfa.DFA;
import de.sfuhrm.htmltosax.parser.dfa.Transition;
import de.sfuhrm.htmltosax.parser.html.HtmlEntities;
import de.sfuhrm.htmltosax.parser.html.HtmlState;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class HtmlDFA
extends DFA {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlDFA.class);
    private static final String DEFAULT_URI = "";
    private static final String DEFAULT_LOCAL_NAME = "";
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITS = "0123456789";
    private static final String SPACE = " \t\r\n";
    private int lastMarkPosition;
    private String currentElementName;
    private String currentAttributeName;
    private Map<String, String> currentAttributes = new LinkedHashMap<String, String>();
    private static final Action<HtmlDFA> EmitErrorAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            int len = in.length();
            int limit = 16;
            if (len > 16) {
                len = 16;
            }
            String excerpt = in.substring(in.length() - len, in.length());
            String msg = "General parsing error at position " + dfa.pos() + ", state: " + transition.from() + ", context before: " + excerpt;
            if (dfa.errorHandler != null) {
                dfa.errorHandler.error(new SAXParseException(msg, dfa.createLocator()));
            }
        }
    };
    private static final Action<HtmlDFA> ElementNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            try {
                dfa.currentElementName = HtmlDFA.toElementName(dfa, in);
            }
            catch (SAXParseException spe) {
                if (dfa.errorHandler != null) {
                    dfa.errorHandler.error(spe);
                }
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Seen element named {}", (Object)dfa.currentElementName);
            }
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> AttributeNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            try {
                dfa.currentAttributeName = HtmlDFA.toAttributeName(dfa, in);
            }
            catch (SAXParseException spe) {
                if (dfa.errorHandler != null) {
                    dfa.errorHandler.error(spe);
                }
                return;
            }
            dfa.currentAttributes.put(dfa.currentAttributeName, dfa.currentAttributeName);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Seen attribute named {}", (Object)dfa.currentAttributeName);
            }
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> AttributeValueAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            String v = HtmlDFA.toAttributeValue(in);
            dfa.currentAttributes.put(dfa.currentAttributeName, v);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Seen attribute named {} and valued {}", new Object[]{dfa.currentAttributeName, v});
            }
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> BeforeElementNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            dfa.currentAttributes.clear();
            dfa.currentAttributeName = null;
            dfa.currentElementName = null;
        }
    };
    private static final Action<HtmlDFA> HandlerStartElementNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            ContentHandler handler = dfa.contentHandler;
            if (dfa.currentElementName == null) {
                throw new IllegalStateException("Element name expected at " + dfa.pos() + ", but not given");
            }
            if (handler != null) {
                AttributesImpl attrs = new AttributesImpl();
                for (Map.Entry entry : dfa.currentAttributes.entrySet()) {
                    attrs.addAttribute("", "", (String)entry.getKey(), "", (String)entry.getValue());
                }
                handler.startElement("", "", dfa.currentElementName, attrs);
            }
            in.setLength(0);
            if (dfa.currentElementName.equalsIgnoreCase("script")) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Switching to script mode");
                }
                dfa.forceTo(HtmlState.WAIT_SCRIPT_END);
            }
        }
    };
    private static final Action<HtmlDFA> HandlerEndElementNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            ContentHandler handler = dfa.contentHandler;
            String name = dfa.currentElementName;
            if (name == null) {
                throw new IllegalStateException("element name is empty");
            }
            if (handler != null) {
                handler.endElement("", "", name);
            }
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> HandlerEndScriptElementNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            ContentHandler handler = dfa.contentHandler;
            String name = "script";
            if (handler != null) {
                handler.endElement("", "", name);
            }
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> MarkPositionAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            dfa.lastMarkPosition = in.length() - 1;
        }
    };
    @Deprecated
    private static final Action<HtmlDFA> ClearElementNameAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            dfa.currentElementName = null;
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> HandlerCharactersAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            if (in.length() == 0) {
                return;
            }
            String txt = HtmlDFA.toText(in);
            ContentHandler handler = dfa.contentHandler;
            if (handler != null) {
                char[] carr = txt.toCharArray();
                handler.characters(carr, 0, carr.length);
            }
            in.setLength(0);
        }
    };
    private static final Action<HtmlDFA> AmpAndNoEntityReferenceAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Mistaken entity ref, ignoring", (Object)in);
            }
        }
    };
    private static final Action<HtmlDFA> EntityReferenceAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            String all = in.toString();
            String entity = all.substring(dfa.lastMarkPosition);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Entity reference: {}", (Object)entity);
            }
            Integer codePoint = HtmlEntities.getInstance().get(entity, true);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolved code point: {}", (Object)codePoint);
            }
            if (codePoint != null) {
                in.setLength(in.length() - entity.length());
                in.append((char)codePoint.intValue());
            } else {
                LOGGER.warn("Unknown entity reference {}", (Object)entity);
                if (dfa.errorHandler != null) {
                    dfa.errorHandler.warning(new SAXParseException("Unknown entity: " + entity, dfa.createLocator()));
                }
            }
        }
    };
    private static final Action<HtmlDFA> NumericReferenceAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            block3: {
                String all = in.toString();
                String numeric = all.substring(dfa.lastMarkPosition);
                LOGGER.debug("Numeric reference: {}", (Object)numeric);
                try {
                    int intNumeric = Integer.parseInt(numeric.substring(2, numeric.length() - 1));
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Parsed number: {}", (Object)intNumeric);
                    }
                    in.setLength(in.length() - numeric.length());
                    in.append((char)intNumeric);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Malformatted numeric character reference {}", (Object)numeric);
                    if (dfa.errorHandler == null) break block3;
                    dfa.errorHandler.warning(new SAXParseException("Malformatted numeric character reference " + numeric, dfa.createLocator()));
                }
            }
        }
    };
    private static final Action<HtmlDFA> HexReferenceAction = new Action<HtmlDFA>(){

        @Override
        public void fire(HtmlDFA dfa, Transition transition, StringBuilder in) throws Exception {
            block5: {
                String all = in.toString();
                String numeric = all.substring(dfa.lastMarkPosition);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Hex reference: {}", (Object)numeric);
                }
                String hexPart = numeric.substring(3, numeric.length() - 1);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Hex part: {}", (Object)hexPart);
                }
                try {
                    int intNumeric = Integer.parseInt(hexPart, 16);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Parsed number: {}", (Object)intNumeric);
                    }
                    in.setLength(in.length() - numeric.length());
                    in.append((char)intNumeric);
                }
                catch (NumberFormatException e) {
                    LOGGER.warn("Malformatted hex character reference {}", (Object)numeric);
                    if (dfa.errorHandler == null) break block5;
                    dfa.errorHandler.warning(new SAXParseException("Malformatted hex character reference " + numeric, dfa.createLocator()));
                }
            }
        }
    };
    private static final List<Transition<HtmlDFA>> fixedTransitions = Arrays.asList(new Transition(HtmlState.INIT, "<", HtmlState.LT, Transition.DeleteLastAction, HandlerCharactersAction), new Transition(HtmlState.INIT, "&", HtmlState.AMP, MarkPositionAction), new Transition(HtmlState.INIT, "", HtmlState.INIT, HandlerCharactersAction), new Transition(HtmlState.LT, ">", HtmlState.INIT, new Action[0]), new Transition(HtmlState.LT, "/", HtmlState.CLOSE_TAG, Transition.ClearAction), new Transition(HtmlState.LT, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", HtmlState.ELEMENT_NAME, BeforeElementNameAction), new Transition(HtmlState.LT, "!", HtmlState.WAIT_GT, new Action[0]), new Transition(HtmlState.LT, " \t\r\n", HtmlState.INIT, EmitErrorAction), new Transition(HtmlState.WAIT_GT, null, HtmlState.WAIT_GT, Transition.DeleteLastAction), new Transition(HtmlState.WAIT_GT, ">", HtmlState.INIT, new Action[0]), new Transition(HtmlState.ELEMENT_NAME, "/", HtmlState.AFTER_ELEMENT_NAME_SLASH, Transition.DeleteLastAction, ElementNameAction), new Transition(HtmlState.ELEMENT_NAME, ">", HtmlState.INIT, Transition.DeleteLastAction, ElementNameAction, HandlerStartElementNameAction, ClearElementNameAction), new Transition(HtmlState.ELEMENT_NAME, " \t\r\n", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction, ElementNameAction), new Transition(HtmlState.AFTER_ELEMENT_NAME, ">", HtmlState.INIT, Transition.DeleteLastAction, HandlerStartElementNameAction, ClearElementNameAction), new Transition(HtmlState.AFTER_ELEMENT_NAME, "/", HtmlState.AFTER_ELEMENT_NAME_SLASH, Transition.DeleteLastAction), new Transition(HtmlState.AFTER_ELEMENT_NAME, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", HtmlState.ATTRIBUTE_NAME, new Action[0]), new Transition(HtmlState.AFTER_ELEMENT_NAME, " \t\r\n", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction), new Transition(HtmlState.AFTER_ELEMENT_NAME_SLASH, ">", HtmlState.INIT, HandlerStartElementNameAction, HandlerEndElementNameAction, ClearElementNameAction), new Transition(HtmlState.ATTRIBUTE_NAME, ">", HtmlState.INIT, Transition.DeleteLastAction, AttributeNameAction, HandlerStartElementNameAction, ClearElementNameAction), new Transition(HtmlState.ATTRIBUTE_NAME, "=", HtmlState.BEFORE_ATTRIBUTE_VALUE, Transition.DeleteLastAction, AttributeNameAction, Transition.ClearAction), new Transition(HtmlState.ATTRIBUTE_NAME, " \t\r\n", HtmlState.AFTER_ATTRIBUTE_NAME, Transition.DeleteLastAction, AttributeNameAction, Transition.ClearAction), new Transition(HtmlState.AFTER_ATTRIBUTE_NAME, "=", HtmlState.BEFORE_ATTRIBUTE_VALUE, Transition.DeleteLastAction), new Transition(HtmlState.AFTER_ATTRIBUTE_NAME, " \t\r\n", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction), new Transition(HtmlState.AFTER_ATTRIBUTE_NAME, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", HtmlState.ATTRIBUTE_NAME, new Action[0]), new Transition(HtmlState.AFTER_ATTRIBUTE_NAME, ">", HtmlState.INIT, Transition.DeleteLastAction, HandlerStartElementNameAction, ClearElementNameAction), new Transition(HtmlState.BEFORE_ATTRIBUTE_VALUE, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ", HtmlState.ATTRIBUTE_VALUE, new Action[0]), new Transition(HtmlState.BEFORE_ATTRIBUTE_VALUE, " \t\r\n", HtmlState.BEFORE_ATTRIBUTE_VALUE, Transition.DeleteLastAction), new Transition(HtmlState.BEFORE_ATTRIBUTE_VALUE, "'", HtmlState.SQ_ATTRIBUTE_VALUE, Transition.DeleteLastAction), new Transition(HtmlState.BEFORE_ATTRIBUTE_VALUE, "\"", HtmlState.DQ_ATTRIBUTE_VALUE, Transition.DeleteLastAction), new Transition(HtmlState.BEFORE_ATTRIBUTE_VALUE, ">", HtmlState.INIT, Transition.DeleteLastAction, HandlerStartElementNameAction, ClearElementNameAction), new Transition(HtmlState.ATTRIBUTE_VALUE, " \t\r\n", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction, AttributeValueAction, Transition.ClearAction), new Transition(HtmlState.ATTRIBUTE_VALUE, ">", HtmlState.INIT, Transition.DeleteLastAction, AttributeValueAction, HandlerStartElementNameAction, Transition.ClearAction), new Transition(HtmlState.SQ_ATTRIBUTE_VALUE, "'", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction, AttributeValueAction, Transition.ClearAction), new Transition(HtmlState.SQ_ATTRIBUTE_VALUE, "&", HtmlState.SQ_AMP, MarkPositionAction), new Transition(HtmlState.SQ_AMP, "'", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction, AttributeValueAction, Transition.ClearAction), new Transition(HtmlState.SQ_ATTRIBUTE_VALUE, "\n\r", HtmlState.SQ_ATTRIBUTE_VALUE, EmitErrorAction, Transition.DeleteLastAction), new Transition(HtmlState.DQ_ATTRIBUTE_VALUE, "\"", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction, AttributeValueAction, Transition.ClearAction), new Transition(HtmlState.DQ_ATTRIBUTE_VALUE, "&", HtmlState.DQ_AMP, MarkPositionAction), new Transition(HtmlState.DQ_ATTRIBUTE_VALUE, "\n\r", HtmlState.DQ_ATTRIBUTE_VALUE, EmitErrorAction, Transition.DeleteLastAction), new Transition(HtmlState.DQ_AMP, "\"", HtmlState.AFTER_ELEMENT_NAME, Transition.DeleteLastAction, AttributeValueAction, Transition.ClearAction), new Transition(HtmlState.CLOSE_TAG, ">", HtmlState.INIT, Transition.DeleteLastAction, ElementNameAction, HandlerEndElementNameAction, ClearElementNameAction), new Transition(HtmlState.CLOSE_TAG, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", HtmlState.CLOSE_TAG, new Action[0]), new Transition(HtmlState.CLOSE_TAG, null, HtmlState.CLOSE_TAG, Transition.DeleteLastAction), new Transition(HtmlState.WAIT_SCRIPT_END, "<", HtmlState.WSE_LT, new Action[0]), new Transition(HtmlState.WSE_LT, "/", HtmlState.WSE_LTS, new Action[0]), new Transition(HtmlState.WSE_LT, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS, "sS", HtmlState.WSE_LTS_S, new Action[0]), new Transition(HtmlState.WSE_LTS, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS_S, "cC", HtmlState.WSE_LTS_SC, new Action[0]), new Transition(HtmlState.WSE_LTS_S, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS_SC, "rR", HtmlState.WSE_LTS_SCR, new Action[0]), new Transition(HtmlState.WSE_LTS_SC, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS_SCR, "iI", HtmlState.WSE_LTS_SCRI, new Action[0]), new Transition(HtmlState.WSE_LTS_SCR, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS_SCRI, "pP", HtmlState.WSE_LTS_SCRIP, new Action[0]), new Transition(HtmlState.WSE_LTS_SCRI, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS_SCRIP, "tT", HtmlState.WSE_LTS_SCRIPT, new Action[0]), new Transition(HtmlState.WSE_LTS_SCRIP, null, HtmlState.WAIT_SCRIPT_END, new Action[0]), new Transition(HtmlState.WSE_LTS_SCRIPT, ">", HtmlState.INIT, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, Transition.DeleteLastAction, HandlerCharactersAction, HandlerEndScriptElementNameAction), new Transition(HtmlState.WSE_LTS_SCRIPT, null, HtmlState.WAIT_SCRIPT_END, Transition.DeleteLastAction));

    public HtmlDFA(Reader r) {
        super(r, HtmlState.INIT);
        this.init(HtmlDFA.createTransitions().toArray(new Transition[0]));
        try {
            HtmlEntities.getInstance();
        }
        catch (IOException ex) {
            throw new Error("Internal Error", ex);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    private Locator createLocator() {
        return new Locator(){

            @Override
            public String getPublicId() {
                return null;
            }

            @Override
            public String getSystemId() {
                return null;
            }

            @Override
            public int getLineNumber() {
                return HtmlDFA.this.line();
            }

            @Override
            public int getColumnNumber() {
                return HtmlDFA.this.column();
            }
        };
    }

    private static List<Transition<HtmlDFA>> createAmpTransitions(HtmlState ampEntry, HtmlState ampEntity, HtmlState ampNumeric, HtmlState ampHex, HtmlState ampExit) {
        List<Transition<HtmlDFA>> result = Arrays.asList(new Transition(ampEntry, CHARS, ampEntity, new Action[0]), new Transition(ampEntry, "#", ampNumeric, new Action[0]), new Transition(ampEntry, null, ampExit, EmitErrorAction), new Transition(ampEntity, ";", ampExit, EntityReferenceAction), new Transition(ampEntity, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789", ampEntity, new Action[0]), new Transition(ampEntity, null, ampExit, AmpAndNoEntityReferenceAction), new Transition(ampNumeric, ";", ampExit, NumericReferenceAction), new Transition(ampNumeric, "x", ampHex, new Action[0]), new Transition(ampNumeric, DIGITS, ampNumeric, new Action[0]), new Transition(ampNumeric, null, ampExit, EmitErrorAction), new Transition(ampHex, "0123456789abcdefABCDEF", HtmlState.AMP_HEX_REF, new Action[0]), new Transition(ampHex, null, ampExit, EmitErrorAction), new Transition(ampHex, ";", ampExit, HexReferenceAction));
        return result;
    }

    private static List<Transition<HtmlDFA>> createTransitions() {
        ArrayList<Transition<HtmlDFA>> result = new ArrayList<Transition<HtmlDFA>>();
        result.addAll(fixedTransitions);
        result.addAll(HtmlDFA.createAmpTransitions(HtmlState.AMP, HtmlState.AMP_ENTITY_REF, HtmlState.AMP_NUMERIC_REF, HtmlState.AMP_HEX_REF, HtmlState.INIT));
        result.addAll(HtmlDFA.createAmpTransitions(HtmlState.SQ_AMP, HtmlState.SQ_AMP_ENTITY_REF, HtmlState.SQ_AMP_NUMERIC_REF, HtmlState.SQ_AMP_HEX_REF, HtmlState.SQ_ATTRIBUTE_VALUE));
        result.addAll(HtmlDFA.createAmpTransitions(HtmlState.DQ_AMP, HtmlState.DQ_AMP_ENTITY_REF, HtmlState.DQ_AMP_NUMERIC_REF, HtmlState.DQ_AMP_HEX_REF, HtmlState.DQ_ATTRIBUTE_VALUE));
        return result;
    }

    private static String toElementName(HtmlDFA dfa, CharSequence in) throws SAXParseException {
        if (in.length() == 0) {
            throw new SAXParseException("Element name is empty", dfa.createLocator());
        }
        String str = in.toString();
        if (str.contains(" ")) {
            throw new SAXParseException("Element name with space at in \"" + in + "\"", dfa.createLocator());
        }
        return str.toLowerCase();
    }

    private static String toAttributeName(HtmlDFA dfa, CharSequence in) throws SAXParseException {
        if (in.length() == 0) {
            throw new SAXParseException("Attr name is empty", dfa.createLocator());
        }
        String str = in.toString();
        if (str.contains(" ")) {
            throw new SAXParseException("Attr name with space at in \"" + in + "\"", dfa.createLocator());
        }
        return str.toLowerCase();
    }

    private static String toAttributeValue(CharSequence in) {
        return in.toString();
    }

    private static String toText(CharSequence in) {
        return in.toString();
    }
}

