/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HtmlEntities {
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlEntities.class);
    private static final String PROPERTIES_NAME = "/entities/htmlentities.properties";
    private final Map<String, Integer> map = HtmlEntities.readFromClassPath();
    private static HtmlEntities INSTANCE;

    private HtmlEntities() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> readFromClassPath() throws IOException {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        InputStream is = null;
        try {
            LOGGER.debug("Getting properties URL");
            URL url = HtmlEntities.class.getResource(PROPERTIES_NAME);
            LOGGER.debug("Opening properties URL {}", (Object)url.toExternalForm());
            is = url.openStream();
            LOGGER.debug("Opened properties file");
            Properties props = new Properties();
            LOGGER.debug("Loading properties file");
            props.load(is);
            LOGGER.debug("Loaded properties file");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = (String)entry.getKey();
                if (!name.matches("&.*;")) {
                    throw new IllegalArgumentException("Found illegal entry of the form '" + name + "', expecting regex '&.*;'");
                }
                String value = (String)entry.getValue();
                Integer integerValue = Integer.parseInt(value);
                result.put(name, integerValue);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Put {} = {}", new Object[]{name, integerValue});
            }
            LOGGER.debug("Read " + result.size() + " entries");
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    public static synchronized HtmlEntities getInstance() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = new HtmlEntities();
        }
        return INSTANCE;
    }

    public Integer get(String entityReference) {
        return this.get(entityReference, false);
    }

    public Integer get(String entityReference, boolean fuzzy) {
        Integer result = this.map.get(entityReference);
        if (fuzzy && result == null) {
            result = this.map.get(entityReference.toLowerCase());
        }
        return result;
    }
}

