/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.htmltosax.dom;

import java.io.IOException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DomParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomParser.class);
    private final DocumentBuilder builder;
    private Document document;
    private boolean closed;
    private Node current;
    private final MyDefaultHandler defaultHandler;
    private final Stack<Node> stack;

    private DomParser() throws ParserConfigurationException {
        LOGGER.debug("c'tor");
        this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.closed = false;
        this.defaultHandler = new MyDefaultHandler();
        this.stack = new Stack();
    }

    public static Document parse(InputSource is) throws ParserConfigurationException, SAXException, IOException {
        LOGGER.debug("start");
        SAXParserFactory factory = SAXParserFactory.newInstance("de.sfuhrm.htmltosax.HtmlToSaxParserFactory", null);
        SAXParser parser = factory.newSAXParser();
        DomParser parserInstance = new DomParser();
        LOGGER.debug("calling parse");
        parser.parse(is, (DefaultHandler)parserInstance.defaultHandler);
        LOGGER.debug("called parse");
        LOGGER.debug("end");
        return parserInstance.document;
    }

    private void preWrite() {
        if (this.closed) {
            throw new IllegalStateException("Document already closed");
        }
    }

    private void popTo(String uri, String localName, String qName) {
        int i;
        LOGGER.debug("popping to {} {} {}", new Object[]{uri, localName, qName});
        int idx = -1;
        for (i = this.stack.size() - 1; i >= 0; --i) {
            Node n = (Node)this.stack.elementAt(i);
            if (!n.getNodeName().equals(qName)) continue;
            LOGGER.debug("found element at idx {}", (Object)i);
            idx = i;
            break;
        }
        if (idx != -1) {
            for (i = this.stack.size() - 1; i >= idx; --i) {
                this.stack.removeElementAt(i);
            }
            this.current = this.stack.peek();
        }
    }

    private void setAttrs(Element e, Attributes attrs) {
        for (int i = 0; i < attrs.getLength(); ++i) {
            String name = attrs.getQName(i);
            String val = attrs.getValue(i);
            if (name.contains(":")) {
                LOGGER.warn("Ignoring name containing colon {}", (Object)name);
                continue;
            }
            e.setAttribute(name, val);
        }
    }

    private class MyDefaultHandler
    extends DefaultHandler {
        private MyDefaultHandler() {
        }

        @Override
        public void endDocument() throws SAXException {
            DomParser.this.closed = true;
            DomParser.this.stack.clear();
            DomParser.this.current = null;
        }

        @Override
        public void startDocument() throws SAXException {
            LOGGER.debug("startDocument");
            DomParser.this.document = DomParser.this.builder.newDocument();
            DomParser.this.current = DomParser.this.document;
            DomParser.this.stack.push(DomParser.this.document);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            LOGGER.debug("characters");
            DomParser.this.preWrite();
            if (DomParser.this.current.getNodeType() == 9) {
                LOGGER.warn("Ignoring top level text {}", (Object)new String(ch, start, length));
                return;
            }
            Text text = DomParser.this.document.createTextNode(new String(ch, start, length));
            DomParser.this.current.appendChild(text);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            LOGGER.debug("endElement {}", (Object)qName);
            DomParser.this.popTo(uri, localName, qName);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            LOGGER.debug("startElement {}", (Object)qName);
            DomParser.this.preWrite();
            Element e = DomParser.this.document.createElement(qName);
            if (attributes != null) {
                DomParser.this.setAttrs(e, attributes);
            }
            DomParser.this.current.appendChild(e);
            DomParser.this.current = e;
            DomParser.this.stack.push(e);
        }
    }
}

