/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.openssl4j;

import de.sfuhrm.openssl4j.ObjectTransfer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

class NativeLoader {
    private final Set<Path> loaded = new HashSet<Path>();
    private static boolean isLoaded = false;
    static final String[] OBJECTS = new String[]{"libopenssl4j"};

    NativeLoader() {
    }

    static void loadAll() throws IOException {
        if (isLoaded) {
            return;
        }
        NativeLoader nativeLoader = new NativeLoader();
        ObjectTransfer objectTransfer = new ObjectTransfer();
        objectTransfer.transfer(OBJECTS);
        for (Path path : objectTransfer.getObjectFiles()) {
            nativeLoader.load(path);
        }
        isLoaded = true;
    }

    final void load(Path name) {
        if (!this.loaded.contains(name) && Files.isRegularFile(name, new LinkOption[0])) {
            System.load(name.toString());
            this.loaded.add(name);
        }
    }
}

