/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.ReusableStringBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

final class RowReader
implements Closeable {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final int BUFFER_SIZE = 8192;
    private static final int FIELD_MODE_RESET = 0;
    private static final int FIELD_MODE_QUOTED = 1;
    private static final int FIELD_MODE_NON_QUOTED = 2;
    private static final int FIELD_MODE_QUOTE_ON = 4;
    private static final int FIELD_MODE_QUOTED_EMPTY = 8;
    private final Reader reader;
    private final char fieldSeparator;
    private final char textDelimiter;
    private final char[] buf = new char[8192];
    private final Line line = new Line(32);
    private final ReusableStringBuilder currentField = new ReusableStringBuilder(512);
    private int bufPos;
    private int bufLen;
    private int prevChar = -1;
    private int copyStart;
    private boolean finished;

    RowReader(Reader reader, char fieldSeparator, char textDelimiter) {
        this.reader = reader;
        this.fieldSeparator = fieldSeparator;
        this.textDelimiter = textDelimiter;
    }

    Line readLine() throws IOException {
        Line localLine = this.line.reset();
        ReusableStringBuilder localCurrentField = this.currentField;
        char[] localBuf = this.buf;
        int localBufPos = this.bufPos;
        int localPrevChar = this.prevChar;
        int localCopyStart = this.copyStart;
        int copyLen = 0;
        int fieldMode = 0;
        int lines = 1;
        while (true) {
            if (this.bufLen == localBufPos) {
                if (copyLen > 0) {
                    localCurrentField.append(localBuf, localCopyStart, copyLen);
                }
                this.bufLen = this.reader.read(localBuf, 0, localBuf.length);
                if (this.bufLen < 0) {
                    this.finished = true;
                    if (localPrevChar != this.fieldSeparator && (fieldMode & 8) != 8 && !localCurrentField.hasContent()) break;
                    localLine.addField(localCurrentField.toStringAndReset());
                    break;
                }
                copyLen = 0;
                localBufPos = 0;
                localCopyStart = 0;
            }
            int c = localBuf[localBufPos++];
            if ((fieldMode & 4) != 0) {
                if (c == this.textDelimiter) {
                    fieldMode &= 0xFFFFFFFB;
                    if (copyLen > 0) {
                        localCurrentField.append(localBuf, localCopyStart, copyLen);
                        copyLen = 0;
                    } else {
                        fieldMode |= 8;
                    }
                    localCopyStart = localBufPos;
                } else {
                    if (c == 13 || c == 10 && this.prevChar != 13) {
                        ++lines;
                    }
                    ++copyLen;
                }
            } else if (c == this.fieldSeparator) {
                if (copyLen > 0) {
                    localCurrentField.append(localBuf, localCopyStart, copyLen);
                    copyLen = 0;
                }
                localLine.addField(localCurrentField.toStringAndReset());
                localCopyStart = localBufPos;
                fieldMode = 0;
            } else if (c == this.textDelimiter && (fieldMode & 2) == 0) {
                fieldMode = 5;
                if (localPrevChar == this.textDelimiter) {
                    ++copyLen;
                } else {
                    localCopyStart = localBufPos;
                }
            } else {
                if (c == 13) {
                    if (copyLen > 0) {
                        localCurrentField.append(localBuf, localCopyStart, copyLen);
                    }
                    localLine.addField(localCurrentField.toStringAndReset());
                    localPrevChar = c;
                    localCopyStart = localBufPos;
                    break;
                }
                if (c == 10) {
                    if (localPrevChar != 13) {
                        if (copyLen > 0) {
                            localCurrentField.append(localBuf, localCopyStart, copyLen);
                        }
                        localLine.addField(localCurrentField.toStringAndReset());
                        localPrevChar = c;
                        localCopyStart = localBufPos;
                        break;
                    }
                    localCopyStart = localBufPos;
                } else {
                    ++copyLen;
                    if (fieldMode == 0) {
                        fieldMode = 2;
                    }
                }
            }
            localPrevChar = c;
        }
        this.bufPos = localBufPos;
        this.prevChar = localPrevChar;
        this.copyStart = localCopyStart;
        localLine.setLines(lines);
        return localLine;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public boolean isFinished() {
        return this.finished;
    }

    static final class Line {
        private String[] fields;
        private int linePos;
        private int lines;

        Line(int initialCapacity) {
            this.fields = new String[initialCapacity];
        }

        Line reset() {
            this.linePos = 0;
            this.lines = 1;
            return this;
        }

        void addField(String field) {
            if (this.linePos == this.fields.length) {
                this.fields = Arrays.copyOf(this.fields, this.fields.length * 2);
            }
            this.fields[this.linePos++] = field;
        }

        String[] getFields() {
            return Arrays.copyOf(this.fields, this.linePos);
        }

        int getLines() {
            return this.lines;
        }

        void setLines(int lines) {
            this.lines = lines;
        }
    }
}

