/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.BomHeader;
import de.siegmar.fastcsv.reader.BomUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;

final class BomInputStream
extends InputStream {
    private final InputStream delegate;
    private final Charset charset;
    private final byte[] buffer = new byte[4];
    private int remainingBuffer;

    BomInputStream(InputStream inputStream, Charset defaultCharset) throws IOException {
        this.delegate = inputStream;
        int bufCnt = this.delegate.readNBytes(this.buffer, 0, 4);
        Optional<BomHeader> optHeader = BomUtil.detectCharset(this.buffer);
        if (optHeader.isEmpty()) {
            this.remainingBuffer = bufCnt;
            this.charset = defaultCharset;
        } else {
            BomHeader bomHeader = optHeader.get();
            this.remainingBuffer = bufCnt - bomHeader.getLength();
            this.charset = bomHeader.getCharset();
        }
    }

    Charset getCharset() {
        return this.charset;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.remainingBuffer > 0 ? this.readBuffer(b, off, len) : this.delegate.read(b, off, len);
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException();
    }

    private int readBuffer(byte[] b, int off, int len) {
        int toCopy = Math.min(this.remainingBuffer, len);
        System.arraycopy(this.buffer, this.buffer.length - this.remainingBuffer, b, off, toCopy);
        this.remainingBuffer -= toCopy;
        return toCopy;
    }
}

