/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackawslogsjsonencoder;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.encoder.EncoderBase;
import de.siegmar.logbackawslogsjsonencoder.SimpleJsonEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Marker;

public class AwsJsonLogEncoder
extends EncoderBase<ILoggingEvent> {
    private static final int INITIAL_BUF_SIZE = 128;
    private static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ";
    private static final String DEFAULT_MESSAGE_PATTERN = "%m%nopex";
    private static final String DEFAULT_FULL_MESSAGE_PATTERN = "%m%n";
    private String dateTimeFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ";
    private DateTimeFormatter dateTimeFormatter;
    private boolean includeRawMessage;
    private boolean includeMarker = true;
    private boolean includeMdcData = true;
    private boolean includeCallerData;
    private boolean includeRootCauseData;
    private PatternLayout messageLayout;
    private PatternLayout fullMessageLayout;
    private Map<String, Object> staticFields = new HashMap<String, Object>();

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public boolean isIncludeRawMessage() {
        return this.includeRawMessage;
    }

    public void setIncludeRawMessage(boolean includeRawMessage) {
        this.includeRawMessage = includeRawMessage;
    }

    public boolean isIncludeMarker() {
        return this.includeMarker;
    }

    public void setIncludeMarker(boolean includeMarker) {
        this.includeMarker = includeMarker;
    }

    public boolean isIncludeMdcData() {
        return this.includeMdcData;
    }

    public void setIncludeMdcData(boolean includeMdcData) {
        this.includeMdcData = includeMdcData;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public boolean isIncludeRootCauseData() {
        return this.includeRootCauseData;
    }

    public void setIncludeRootCauseData(boolean includeRootCauseData) {
        this.includeRootCauseData = includeRootCauseData;
    }

    public PatternLayout getMessageLayout() {
        return this.messageLayout;
    }

    public void setMessageLayout(PatternLayout messageLayout) {
        this.messageLayout = messageLayout;
    }

    public PatternLayout getFullMessageLayout() {
        return this.fullMessageLayout;
    }

    public void setFullMessageLayout(PatternLayout fullMessageLayout) {
        this.fullMessageLayout = fullMessageLayout;
    }

    public Map<String, Object> getStaticFields() {
        return this.staticFields;
    }

    public void setStaticFields(Map<String, Object> staticFields) {
        this.staticFields = Objects.requireNonNull(staticFields);
    }

    public void addStaticField(String staticField) {
        String[] split = staticField.split(":", 2);
        if (split.length == 2) {
            this.addField(this.staticFields, split[0].trim(), split[1].trim());
        } else {
            this.addWarn("staticField must be in format key:value - rejecting '" + staticField + "'");
        }
    }

    private void addField(Map<String, Object> dst, String key, String value) {
        if (key.isEmpty()) {
            this.addWarn("staticField key must not be empty");
        } else if (dst.containsKey(key)) {
            this.addWarn("additional field with key '" + key + "' is already set");
        } else {
            dst.put(key, value);
        }
    }

    public void start() {
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(this.dateTimeFormat).withZone(ZoneId.systemDefault());
        if (this.messageLayout == null) {
            this.messageLayout = this.buildPattern(DEFAULT_MESSAGE_PATTERN);
        }
        if (this.fullMessageLayout == null) {
            this.fullMessageLayout = this.buildPattern(DEFAULT_FULL_MESSAGE_PATTERN);
        }
        super.start();
    }

    private PatternLayout buildPattern(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.getContext());
        patternLayout.setPattern(pattern);
        patternLayout.start();
        return patternLayout;
    }

    public byte[] encode(ILoggingEvent event) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(128);
        try (OutputStreamWriter appendable = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);){
            try (SimpleJsonEncoder json = new SimpleJsonEncoder(appendable);){
                Marker marker;
                Instant timestamp = Instant.ofEpochMilli(event.getTimeStamp());
                json.appendToJSON("timestamp", this.dateTimeFormatter.format(timestamp)).appendToJSON("level", event.getLevel().toString()).appendToJSON("logger", event.getLoggerName()).appendToJSON("thread", event.getThreadName()).appendToJSON("message", this.messageLayout.doLayout(event));
                if (event.getThrowableProxy() != null) {
                    json.appendToJSON("full_message", this.fullMessageLayout.doLayout(event));
                }
                if (this.includeRawMessage) {
                    json.appendToJSON("raw_message", event.getMessage());
                }
                if (this.includeMarker && (marker = event.getMarker()) != null) {
                    json.appendToJSON("marker", marker.getName());
                }
                if (this.includeMdcData) {
                    this.append(json, "mdc", this.buildMdcData(event.getMDCPropertyMap()));
                }
                if (this.includeCallerData) {
                    this.append(json, "caller_data", this.buildCallerData(event.getCallerData()));
                }
                if (this.includeRootCauseData) {
                    this.append(json, "root_exception_data", this.buildRootExceptionData(event.getThrowableProxy()));
                }
                if (!this.staticFields.isEmpty()) {
                    json.appendToJSON("static_fields", this.staticFields);
                }
            }
            ((Writer)appendable).append(System.lineSeparator());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bos.toByteArray();
    }

    private void append(SimpleJsonEncoder json, String key, Map<String, Object> values) {
        if (!values.isEmpty()) {
            json.appendToJSON(key, values);
        }
    }

    private Map<String, Object> buildMdcData(Map<String, String> mdcProperties) {
        if (mdcProperties == null || mdcProperties.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> additionalFields = new HashMap<String, Object>();
        mdcProperties.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> this.addField(additionalFields, (String)entry.getKey(), (String)entry.getValue()));
        return additionalFields;
    }

    private Map<String, Object> buildCallerData(StackTraceElement[] callerData) {
        if (callerData == null || callerData.length == 0) {
            return Collections.emptyMap();
        }
        StackTraceElement first = callerData[0];
        HashMap<String, Object> callerDataMap = new HashMap<String, Object>(4);
        callerDataMap.put("source_file_name", first.getFileName());
        callerDataMap.put("source_method_name", first.getMethodName());
        callerDataMap.put("source_class_name", first.getClassName());
        callerDataMap.put("source_line_number", first.getLineNumber());
        return callerDataMap;
    }

    private Map<String, Object> buildRootExceptionData(IThrowableProxy throwableProxy) {
        IThrowableProxy rootException = this.getRootException(throwableProxy);
        if (rootException == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> exceptionDataMap = new HashMap<String, Object>(2);
        exceptionDataMap.put("root_cause_class_name", rootException.getClassName());
        exceptionDataMap.put("root_cause_message", rootException.getMessage());
        return exceptionDataMap;
    }

    private IThrowableProxy getRootException(IThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        IThrowableProxy rootCause = throwableProxy;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] footerBytes() {
        return null;
    }
}

