/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackawslogsjsonencoder;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.Map;

class SimpleJsonEncoder
implements Closeable {
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char QUOTE = '\"';
    private final Appendable appendable;
    private boolean started;
    private boolean closed;

    SimpleJsonEncoder(Appendable appendable) {
        this.appendable = appendable;
        this.append('{');
    }

    private SimpleJsonEncoder append(char c) {
        try {
            this.appendable.append(c);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    private SimpleJsonEncoder append(Object str) {
        try {
            this.appendable.append(str.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this;
    }

    SimpleJsonEncoder appendToJSON(String key, Object value) {
        this.ensureOpen();
        if (value != null) {
            this.appendKey(key);
            this.appendValue(value);
        }
        return this;
    }

    SimpleJsonEncoder appendToJSON(String key, Map<String, Object> values) {
        this.ensureOpen();
        if (values == null) {
            return this;
        }
        this.appendKey(key);
        this.append('{');
        Iterator<Map.Entry<String, Object>> it = values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (entry.getValue() == null) continue;
            this.appendKey(entry.getKey(), false);
            this.appendValue(entry.getValue());
            if (!it.hasNext()) continue;
            this.append(',');
        }
        this.append('}');
        return this;
    }

    private void appendValue(Object value) {
        if (value instanceof Number) {
            this.append(value.toString());
        } else {
            this.append('\"').append(SimpleJsonEncoder.escapeString(value.toString())).append('\"');
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Encoder already closed");
        }
    }

    private void appendKey(String key) {
        this.appendKey(key, this.started);
        this.started = true;
    }

    private void appendKey(String key, boolean prependComma) {
        if (prependComma) {
            this.append(',');
        }
        this.append('\"').append(SimpleJsonEncoder.escapeString(key)).append('\"').append(':');
    }

    private static String escapeString(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        block8: for (char ch : str.toCharArray()) {
            switch (ch) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(ch < ' ' ? SimpleJsonEncoder.escapeCharacter(ch) : Character.valueOf(ch));
                }
            }
        }
        return sb.toString();
    }

    private static String escapeCharacter(char ch) {
        String prefix = ch < '\u0010' ? "000" : (ch < '\u0100' ? "00" : (ch < '\u1000' ? "0" : ""));
        return "\\u" + prefix + Integer.toHexString(ch);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.append('}');
        this.closed = true;
    }
}

