/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackawslogsjsonencoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.encoder.EncoderBase;
import de.siegmar.logbackawslogsjsonencoder.SimpleJsonEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public class AwsJsonLogEncoder
extends EncoderBase<ILoggingEvent> {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private final Map<String, Object> staticFields = new LinkedHashMap<String, Object>();
    private final List<BiConsumer<SimpleJsonEncoder, ILoggingEvent>> mappers = new ArrayList<BiConsumer<SimpleJsonEncoder, ILoggingEvent>>();
    private final List<BiConsumer<SimpleJsonEncoder, ILoggingEvent>> customMappers = new ArrayList<BiConsumer<SimpleJsonEncoder, ILoggingEvent>>();
    private boolean includeTimestamp = true;
    private boolean includeNanoseconds;
    private boolean includeSequenceNumber;
    private boolean includeLevelName = true;
    private boolean includeThreadName = true;
    private boolean includeLoggerName = true;
    private boolean includeFormattedMessage = true;
    private boolean includeRawMessage;
    private boolean includeStacktrace = true;
    private boolean includeRootCause;
    private boolean includeMarker = true;
    private boolean includeMdc = true;
    private boolean includeKeyValues = true;
    private boolean includeCaller;

    public Map<String, Object> getStaticFields() {
        return this.staticFields;
    }

    public void addStaticField(String staticField) {
        String[] split = staticField.split(":", 2);
        if (split.length == 2) {
            this.addField(this.staticFields, split[0].trim(), split[1].trim());
        } else {
            this.addWarn("staticField must be in format key:value - rejecting '" + staticField + "'");
        }
    }

    public List<BiConsumer<SimpleJsonEncoder, ILoggingEvent>> getCustomMappers() {
        return this.customMappers;
    }

    public void addCustomMapper(BiConsumer<SimpleJsonEncoder, ILoggingEvent> customMapper) {
        this.customMappers.add(customMapper);
    }

    public boolean isIncludeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public boolean isIncludeNanoseconds() {
        return this.includeNanoseconds;
    }

    public void setIncludeNanoseconds(boolean includeNanoseconds) {
        this.includeNanoseconds = includeNanoseconds;
    }

    public boolean isIncludeSequenceNumber() {
        return this.includeSequenceNumber;
    }

    public void setIncludeSequenceNumber(boolean includeSequenceNumber) {
        this.includeSequenceNumber = includeSequenceNumber;
    }

    public boolean isIncludeLevelName() {
        return this.includeLevelName;
    }

    public void setIncludeLevelName(boolean includeLevelName) {
        this.includeLevelName = includeLevelName;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean includeThreadName) {
        this.includeThreadName = includeThreadName;
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean includeLoggerName) {
        this.includeLoggerName = includeLoggerName;
    }

    public boolean isIncludeFormattedMessage() {
        return this.includeFormattedMessage;
    }

    public void setIncludeFormattedMessage(boolean includeFormattedMessage) {
        this.includeFormattedMessage = includeFormattedMessage;
    }

    public boolean isIncludeRawMessage() {
        return this.includeRawMessage;
    }

    public void setIncludeRawMessage(boolean includeRawMessage) {
        this.includeRawMessage = includeRawMessage;
    }

    public boolean isIncludeStacktrace() {
        return this.includeStacktrace;
    }

    public void setIncludeStacktrace(boolean includeStacktrace) {
        this.includeStacktrace = includeStacktrace;
    }

    public boolean isIncludeRootCause() {
        return this.includeRootCause;
    }

    public void setIncludeRootCause(boolean includeRootCause) {
        this.includeRootCause = includeRootCause;
    }

    public boolean isIncludeMarker() {
        return this.includeMarker;
    }

    public void setIncludeMarker(boolean includeMarker) {
        this.includeMarker = includeMarker;
    }

    public boolean isIncludeMdc() {
        return this.includeMdc;
    }

    public void setIncludeMdc(boolean includeMdc) {
        this.includeMdc = includeMdc;
    }

    public boolean isIncludeKeyValues() {
        return this.includeKeyValues;
    }

    public void setIncludeKeyValues(boolean includeKeyValues) {
        this.includeKeyValues = includeKeyValues;
    }

    public boolean isIncludeCaller() {
        return this.includeCaller;
    }

    public void setIncludeCaller(boolean includeCaller) {
        this.includeCaller = includeCaller;
    }

    private void addField(Map<String, Object> dst, String key, String value) {
        if (key.isEmpty()) {
            this.addWarn("staticField key must not be empty");
        } else if (dst.containsKey(key)) {
            this.addWarn("additional field with key '" + key + "' is already set");
        } else {
            dst.put(key, value);
        }
    }

    public void start() {
        if (this.includeTimestamp) {
            this.mappers.add((json, event) -> json.append("timestamp", event.getTimeStamp()));
        }
        if (this.includeNanoseconds) {
            this.mappers.add((json, event) -> json.append("nanoseconds", event.getNanoseconds()));
        }
        if (this.includeSequenceNumber) {
            this.mappers.add((json, event) -> json.append("sequenceNumber", event.getSequenceNumber()));
        }
        if (this.includeLevelName) {
            this.mappers.add((json, event) -> json.append("level", event.getLevel().toString()));
        }
        if (this.includeThreadName) {
            this.mappers.add((json, event) -> json.append("thread", event.getThreadName()));
        }
        if (this.includeLoggerName) {
            this.mappers.add((json, event) -> json.append("logger", event.getLoggerName()));
        }
        if (this.includeFormattedMessage) {
            this.mappers.add((json, event) -> json.append("message", event.getFormattedMessage()));
        }
        if (this.includeRawMessage) {
            this.mappers.add((json, event) -> json.append("rawMessage", event.getMessage()));
        }
        if (this.includeMarker) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendMarker(json, event.getMarkerList()));
        }
        if (this.includeMdc) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendMdc(json, event.getMDCPropertyMap()));
        }
        if (this.includeKeyValues) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendKeyValues(json, event.getKeyValuePairs()));
        }
        if (this.includeCaller) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendCaller(json, event.getCallerData()));
        }
        if (this.includeStacktrace) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendThrowable(json, event.getThrowableProxy()));
        }
        if (this.includeRootCause) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendRootCause(json, event.getThrowableProxy()));
        }
        if (!this.staticFields.isEmpty()) {
            this.mappers.add((json, event) -> AwsJsonLogEncoder.appendStaticFields(json, this.staticFields));
        }
        this.mappers.addAll(this.customMappers);
        super.start();
    }

    public byte[] encode(ILoggingEvent event) {
        StringBuilder sb = new StringBuilder(256);
        SimpleJsonEncoder json = new SimpleJsonEncoder(sb);
        this.mappers.forEach(m -> m.accept(json, event));
        json.end();
        sb.append(System.lineSeparator());
        return sb.toString().getBytes(StandardCharsets.UTF_8);
    }

    private static void appendMarker(SimpleJsonEncoder json, List<Marker> markerList) {
        if (markerList == null || markerList.isEmpty()) {
            return;
        }
        json.appendObject("markers", j -> markerList.forEach(marker -> j.append(marker.getName(), 1)));
    }

    private static void appendMdc(SimpleJsonEncoder json, Map<String, String> mdcProperties) {
        if (mdcProperties == null || mdcProperties.isEmpty()) {
            return;
        }
        json.appendObject("mdc", j -> mdcProperties.forEach(j::append));
    }

    private static void appendKeyValues(SimpleJsonEncoder json, List<KeyValuePair> keyValuePairs) {
        if (keyValuePairs == null || keyValuePairs.isEmpty()) {
            return;
        }
        json.appendObject("keyValues", j -> keyValuePairs.forEach(kvp -> j.append(kvp.key, kvp.value)));
    }

    private static void appendCaller(SimpleJsonEncoder json, StackTraceElement[] stackTraceElements) {
        if (stackTraceElements == null || stackTraceElements.length == 0) {
            return;
        }
        StackTraceElement first = stackTraceElements[0];
        json.appendObject("caller", j -> j.append("file", first.getFileName()).append("line", first.getLineNumber()).append("class", first.getClassName()).append("method", first.getMethodName()));
    }

    private static void appendThrowable(SimpleJsonEncoder json, IThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return;
        }
        json.append("stacktrace", ThrowableProxyUtil.asString((IThrowableProxy)throwableProxy));
    }

    private static void appendRootCause(SimpleJsonEncoder json, IThrowableProxy throwableProxy) {
        AwsJsonLogEncoder.findRootException(throwableProxy).ifPresent(rootException -> json.appendObject("rootCause", j -> j.append("class", rootException.getClassName()).append("message", rootException.getMessage())));
    }

    private static Optional<IThrowableProxy> findRootException(IThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return Optional.empty();
        }
        IThrowableProxy rootCause = throwableProxy;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return Optional.of(rootCause);
    }

    private static void appendStaticFields(SimpleJsonEncoder json, Map<String, Object> staticFields) {
        json.appendObject("staticFields", j -> staticFields.forEach(j::append));
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] footerBytes() {
        return null;
    }
}

