/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackawslogsjsonencoder;

import java.util.function.Consumer;

public class SimpleJsonEncoder {
    private static final int JSON_MAX_DEPTH = 8;
    private static final char OPEN_BRACE = '{';
    private static final char CLOSE_BRACE = '}';
    private static final char QUOTE = '\"';
    private static final char COLON = ':';
    private static final char COMMA = ',';
    private static final String NULL = "null";
    private final StringBuilder sb;
    private final boolean[] prependComma = new boolean[8];
    private int currentDepth;

    SimpleJsonEncoder(StringBuilder sb) {
        this.sb = sb;
        sb.append('{');
    }

    public SimpleJsonEncoder append(String key, Object value) {
        return this.appendKey(key).appendValue(value);
    }

    public SimpleJsonEncoder appendObject(String key, Consumer<SimpleJsonEncoder> consumer) {
        this.appendKey(key);
        this.sb.append('{');
        ++this.currentDepth;
        consumer.accept(this);
        this.end();
        return this;
    }

    private SimpleJsonEncoder appendKey(String key) {
        if (this.prependComma[this.currentDepth]) {
            this.sb.append(',');
        } else {
            this.prependComma[this.currentDepth] = true;
        }
        CharSequence keyVal = key == null ? NULL : SimpleJsonEncoder.escapeString(key);
        this.sb.append('\"').append(keyVal).append('\"').append(':');
        return this;
    }

    private SimpleJsonEncoder appendValue(Object value) {
        if (value == null) {
            this.sb.append(NULL);
        } else if (value instanceof Number) {
            this.sb.append(value);
        } else {
            this.sb.append('\"').append((CharSequence)SimpleJsonEncoder.escapeString(value.toString())).append('\"');
        }
        return this;
    }

    void end() {
        this.sb.append('}');
        this.prependComma[this.currentDepth--] = false;
    }

    private static StringBuilder escapeString(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        block8: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': 
                case '/': 
                case '\\': {
                    sb.append('\\');
                    sb.append(ch);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                default: {
                    sb.append(ch < ' ' ? SimpleJsonEncoder.escapeCharacter(ch) : Character.valueOf(ch));
                }
            }
        }
        return sb;
    }

    private static String escapeCharacter(char ch) {
        String prefix = ch < '\u0010' ? "000" : (ch < '\u0100' ? "00" : (ch < '\u1000' ? "0" : ""));
        return "\\u" + prefix + Integer.toHexString(ch);
    }
}

