/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.GelfTcpAppender;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class GelfTcpTlsAppender
extends GelfTcpAppender {
    private boolean trustAllCertificates;
    private SSLSocketFactory socketFactory;

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    @Override
    protected void startAppender() throws IOException {
        super.startAppender();
        try {
            this.socketFactory = this.initSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
    }

    private SSLSocketFactory initSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        if (this.trustAllCertificates) {
            this.addWarn("Enable trustAllCertificates - don't use this in production!");
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, GelfTcpTlsAppender.buildNoopTrustManagers(), new SecureRandom());
            return context.getSocketFactory();
        }
        return (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    private static TrustManager[] buildNoopTrustManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
    }

    @Override
    protected Socket getSocket() throws IOException {
        SSLSocket socket = (SSLSocket)this.socketFactory.createSocket();
        socket.connect(new InetSocketAddress(this.getGraylogHost(), this.getGraylogPort()), this.getConnectTimeout());
        return socket;
    }
}

