/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.UUID;

class GelfUdpChunker {
    private static final int MAX_CHUNKS = 128;
    private static final byte[] CHUNKED_GELF_HEADER = new byte[]{30, 15};
    private static final int MESSAGE_ID_LENGTH = 8;
    private static final int SEQ_COUNT_LENGTH = 2;
    private static final int HEADER_LENGTH = CHUNKED_GELF_HEADER.length + 8 + 2;
    private static final int MIN_CHUNK_SIZE = HEADER_LENGTH + 1;
    private static final int DEFAULT_CHUNK_SIZE = 508;
    private static final int MAX_CHUNK_SIZE = 65467;
    private static final int MAX_CHUNK_PAYLOAD_SIZE = 65467 - HEADER_LENGTH;
    private final String hostname = this.buildHostname();
    private final int maxChunkPayloadSize;

    GelfUdpChunker() {
        this(null);
    }

    GelfUdpChunker(Integer maxChunkSize) {
        if (maxChunkSize != null) {
            if (maxChunkSize < MIN_CHUNK_SIZE) {
                throw new IllegalArgumentException("Minimum chunk size is " + MIN_CHUNK_SIZE);
            }
            if (maxChunkSize > 65467) {
                throw new IllegalArgumentException("Maximum chunk size is 65467");
            }
        }
        int mcs = maxChunkSize != null ? maxChunkSize : 508;
        this.maxChunkPayloadSize = mcs - HEADER_LENGTH;
    }

    private String buildHostname() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return UUID.randomUUID().toString();
        }
    }

    private static ByteBuffer buildChunk(byte[] messageId, byte[] message, byte chunkCount, byte chunkNo, int maxChunkPayloadSize) {
        int chunkPayloadSize = Math.min(maxChunkPayloadSize, message.length - chunkNo * maxChunkPayloadSize);
        ByteBuffer byteBuffer = ByteBuffer.allocate(HEADER_LENGTH + chunkPayloadSize);
        byteBuffer.put(CHUNKED_GELF_HEADER);
        byteBuffer.put(messageId);
        byteBuffer.put(chunkNo);
        byteBuffer.put(chunkCount);
        byteBuffer.put(message, chunkNo * maxChunkPayloadSize, chunkPayloadSize);
        byteBuffer.flip();
        return byteBuffer;
    }

    private byte[] buildMessageId() {
        byte[] messageIdSource = (this.hostname + System.nanoTime()).getBytes(StandardCharsets.UTF_8);
        return Arrays.copyOf(GelfUdpChunker.md5(messageIdSource), 8);
    }

    private static byte[] md5(byte[] data) {
        try {
            return MessageDigest.getInstance("MD5").digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    Iterable<? extends ByteBuffer> chunks(final byte[] message) {
        return new Iterable<ByteBuffer>(){

            @Override
            public Iterator<ByteBuffer> iterator() {
                return new ChunkIterator(message);
            }
        };
    }

    private final class ChunkIterator
    implements Iterator<ByteBuffer> {
        private final byte[] message;
        private final int chunkSize;
        private final byte chunkCount;
        private final byte[] messageId;
        private byte chunkIdx;

        private ChunkIterator(byte[] message) {
            this.message = message;
            int localChunkSize = GelfUdpChunker.this.maxChunkPayloadSize;
            int localChunkCount = this.calcChunkCount(message, localChunkSize);
            if (localChunkCount > 128) {
                localChunkSize = MAX_CHUNK_PAYLOAD_SIZE;
                localChunkCount = this.calcChunkCount(message, localChunkSize);
            }
            if (localChunkCount > 128) {
                throw new IllegalArgumentException("Message to big (" + message.length + " B)");
            }
            this.chunkSize = localChunkSize;
            this.chunkCount = (byte)localChunkCount;
            this.messageId = localChunkCount > 1 ? GelfUdpChunker.this.buildMessageId() : null;
        }

        private int calcChunkCount(byte[] msg, int cs) {
            return (msg.length + cs - 1) / cs;
        }

        @Override
        public boolean hasNext() {
            return this.chunkIdx < this.chunkCount;
        }

        @Override
        public ByteBuffer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("All " + this.chunkCount + " chunks consumed");
            }
            if (this.chunkCount == 1) {
                this.chunkIdx = (byte)(this.chunkIdx + 1);
                return ByteBuffer.wrap(this.message);
            }
            byte by = this.chunkIdx;
            this.chunkIdx = (byte)(by + 1);
            return GelfUdpChunker.buildChunk(this.messageId, this.message, this.chunkCount, by, this.chunkSize);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

