/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.SimpleJsonEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;

public class GelfMessage {
    private static final String VERSION = "1.1";
    private static final int INITIAL_SIZE = 256;
    private final String host;
    private final String shortMessage;
    private final String fullMessage;
    private final long timestamp;
    private final int level;
    private final Map<String, Object> additionalFields;

    GelfMessage(String host, String shortMessage, String fullMessage, long timestamp, int level, Map<String, Object> additionalFields) {
        this.host = Objects.requireNonNull(host, "host must not be null");
        this.shortMessage = Objects.requireNonNull(shortMessage, "shortMessage must not be null");
        this.fullMessage = fullMessage == null || fullMessage.isEmpty() ? null : fullMessage;
        this.timestamp = timestamp;
        this.level = level;
        this.additionalFields = Objects.requireNonNull(additionalFields, "additionalFields must not be null");
    }

    public String getHost() {
        return this.host;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public String getFullMessage() {
        return this.fullMessage;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getLevel() {
        return this.level;
    }

    public Map<String, Object> getAdditionalFields() {
        return this.additionalFields;
    }

    byte[] toJSON() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(256);
        try (SimpleJsonEncoder jsonEncoder = new SimpleJsonEncoder(new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8));){
            jsonEncoder.appendToJSON("version", VERSION).appendToJSON("host", this.host).appendToJSON("short_message", this.shortMessage).appendToJSON("full_message", this.fullMessage).appendToJSONUnquoted("timestamp", GelfMessage.timestampToGelfNotation(this.timestamp)).appendToJSONUnquoted("level", this.level);
            this.additionalFields.forEach((key, value) -> jsonEncoder.appendToJSON('_' + key, value));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bos.toByteArray();
    }

    private static String timestampToGelfNotation(long timestamp) {
        return new BigDecimal(timestamp).movePointLeft(3).toPlainString();
    }
}

