/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf.mappers;

import ch.qos.logback.classic.spi.ILoggingEvent;
import de.siegmar.logbackgelf.mappers.AbstractFixedNameFieldMapper;
import java.util.Iterator;
import java.util.Optional;
import org.slf4j.Marker;

public class MarkerFieldMapper
extends AbstractFixedNameFieldMapper<String> {
    public MarkerFieldMapper(String fieldName) {
        super(fieldName);
    }

    @Override
    protected Optional<String> getValue(ILoggingEvent event) {
        return Optional.ofNullable(event.getMarker()).map(MarkerFieldMapper::buildMarkerStr);
    }

    private static String buildMarkerStr(Marker marker) {
        if (!marker.hasReferences()) {
            return marker.getName();
        }
        StringBuilder sb = new StringBuilder(marker.getName());
        Iterator it = marker.iterator();
        do {
            sb.append(", ").append(((Marker)it.next()).getName());
        } while (it.hasNext());
        return sb.toString();
    }
}

